/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaCodec;
import com.kreative.bitsnpicas.puaa.PuaaUtility;
import com.kreative.bitsnpicas.truetype.PuaaSubtable;
import com.kreative.bitsnpicas.truetype.PuaaSubtableEntry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidiBracketsCodec
extends PuaaCodec {
    @Override
    public String getFileName() {
        return "BidiBrackets.txt";
    }

    @Override
    public String[] getPropertyNames() {
        return new String[]{"Bidi_Paired_Bracket", "Bidi_Paired_Bracket_Type"};
    }

    @Override
    public void compile(PuaaTable puaaTable, Scanner scanner) {
        Object object;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        while (scanner.hasNextLine()) {
            object = PuaaUtility.splitLine(scanner.nextLine());
            if (object == null || ((String[])object).length < 3) continue;
            try {
                int[] nArray = PuaaUtility.splitRange((String)object[0]);
                int n = Integer.parseInt(((String)object[1]).trim(), 16);
                String string = ((String)object[2]).trim();
                for (int i = nArray[0]; i <= nArray[1]; ++i) {
                    hashMap.put(i, n);
                    hashMap2.put(i, string);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        object = puaaTable.getOrCreateSubtable("Bidi_Paired_Bracket");
        ((ArrayList)object).addAll(PuaaUtility.createEntriesFromHexadecimalMap(hashMap));
        object = puaaTable.getOrCreateSubtable("Bidi_Paired_Bracket_Type");
        ((ArrayList)object).addAll(PuaaUtility.createEntriesFromStringMap(hashMap2));
    }

    @Override
    public void decompile(PuaaTable puaaTable, PrintWriter printWriter) {
        PuaaSubtable puaaSubtable = puaaTable.getSubtable("Bidi_Paired_Bracket");
        PuaaSubtable puaaSubtable2 = puaaTable.getSubtable("Bidi_Paired_Bracket_Type");
        TreeMap<Integer, String[]> treeMap = new TreeMap<Integer, String[]>();
        if (puaaSubtable != null) {
            for (String[] stringArray : puaaSubtable) {
                BidiBracketsCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 1);
            }
        }
        if (puaaSubtable2 != null) {
            for (String[] stringArray : puaaSubtable2) {
                BidiBracketsCodec.addLine(treeMap, (PuaaSubtableEntry)stringArray, 2);
            }
        }
        for (String[] stringArray : treeMap.values()) {
            printWriter.println(PuaaUtility.joinLine(stringArray, "; "));
        }
    }

    private static void addLine(TreeMap<Integer, String[]> treeMap, PuaaSubtableEntry puaaSubtableEntry, int n) {
        for (int i = puaaSubtableEntry.firstCodePoint; i <= puaaSubtableEntry.lastCodePoint; ++i) {
            String[] stringArray;
            String string = puaaSubtableEntry.getPropertyValue(i);
            if (string == null || string.length() == 0) continue;
            if (treeMap.containsKey(i)) {
                stringArray = treeMap.get(i);
                if (stringArray[n] == null) {
                    stringArray[n] = string;
                    continue;
                }
                int n2 = n;
                stringArray[n2] = stringArray[n2] + string;
                continue;
            }
            stringArray = new String[3];
            stringArray[0] = PuaaUtility.toHexString(i);
            stringArray[n] = string;
            treeMap.put(i, stringArray);
        }
    }
}

