/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaCodec;
import com.kreative.bitsnpicas.puaa.PuaaCodecRegistry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class PuaaDecompiler {
    private static final PuaaCodecRegistry registry = PuaaCodecRegistry.instance;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length == 0) {
            PuaaDecompiler.printHelp();
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<File> arrayList3 = arrayList;
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n++];
            if (bl && ((String)object).startsWith("-")) {
                if (((String)object).equals("--")) {
                    bl = false;
                    continue;
                }
                if (((String)object).equals("-i") && n < stringArray.length) {
                    arrayList.add(new File(stringArray[n++]));
                    continue;
                }
                if (((String)object).equals("-o") && n < stringArray.length) {
                    arrayList2.add(new File(stringArray[n++]));
                    continue;
                }
                if (((String)object).equals("-I")) {
                    arrayList3 = arrayList;
                    continue;
                }
                if (((String)object).equals("-O")) {
                    arrayList3 = arrayList2;
                    continue;
                }
                if (((String)object).equals("--help")) {
                    PuaaDecompiler.printHelp();
                    continue;
                }
                System.err.println("Unknown option: " + object);
                continue;
            }
            arrayList3.add(new File((String)object));
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (arrayList2.isEmpty()) {
            arrayList2.add(new File("puaa.d"));
        }
        if (arrayList.size() == 1) {
            object = PuaaDecompiler.read((File)arrayList.get(0));
            if (object != null) {
                for (File file : arrayList2) {
                    PuaaDecompiler.write(object, file);
                }
            }
            return;
        }
        if (arrayList2.size() == 1) {
            for (File file : arrayList) {
                PuaaTable puaaTable = PuaaDecompiler.read(file);
                if (puaaTable == null) continue;
                PuaaDecompiler.write(puaaTable, (File)arrayList2.get(0));
            }
            return;
        }
        if (arrayList.size() > 1) {
            System.err.println("Too many input files.");
        }
        if (arrayList2.size() > 1) {
            System.err.println("Too many output files.");
        }
    }

    private static PuaaTable read(File file) {
        System.out.print("Reading " + file.getName() + "...");
        try {
            PuaaTable puaaTable = PuaaDecompiler.extract(file);
            if (puaaTable == null) {
                System.out.println(" ERROR: table not found");
            } else {
                System.out.println(" DONE");
            }
            return puaaTable;
        }
        catch (IOException iOException) {
            System.out.println(" ERROR: " + iOException);
            return null;
        }
    }

    private static void write(PuaaTable puaaTable, File file) {
        System.out.print("Writing " + file.getName() + "...");
        try {
            file.mkdirs();
            PuaaDecompiler.decompile(puaaTable, file);
            System.out.println(" DONE");
        }
        catch (IOException iOException) {
            System.out.println(" ERROR: " + iOException);
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("PuaaDecompiler - Create UCD files from character properties in TrueType files.");
        System.out.println();
        System.out.println("  -i <path>     Specify source TrueType file.");
        System.out.println("  -o <path>     Specify destination directory.");
        System.out.println("  -I            Process arguments as source files.");
        System.out.println("  -O            Process arguments as destination files.");
        System.out.println("  --            Process remaining arguments as file names.");
        System.out.println();
        System.out.println("Output files will be in the format of the Unicode Character Database");
        System.out.println("(although without any comments) and will be named accordingly:");
        System.out.println();
        registry.printFileNames();
        System.out.println();
        System.out.println("Only files for properties present in the source files will be generated.");
        System.out.println();
    }

    public static void decompile(PuaaTable puaaTable, File file) throws IOException {
        block0: for (PuaaCodec puaaCodec : registry.getCodecs()) {
            for (String string : puaaCodec.getPropertyNames()) {
                if (puaaTable.getSubtable(string) == null) continue;
                File file2 = new File(file, puaaCodec.getFileName());
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                PrintWriter printWriter = new PrintWriter((Writer)outputStreamWriter, true);
                puaaCodec.decompile(puaaTable, printWriter);
                printWriter.flush();
                printWriter.close();
                continue block0;
            }
        }
    }

    public static PuaaTable extract(File file) throws IOException {
        long l = file.length();
        if (l < 12L) {
            throw new IOException("file too small");
        }
        if (l > Integer.MAX_VALUE) {
            throw new IOException("file too large");
        }
        byte[] byArray = new byte[(int)l];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        TrueTypeFile trueTypeFile = new TrueTypeFile();
        trueTypeFile.decompile(byArray);
        return (PuaaTable)trueTypeFile.getByTableName("PUAA");
    }
}

