/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class GlyfTableEntry {
    public static final int FLAG_ON_CURVE = 1;
    public static final int FLAG_X_SHORT_VECTOR = 2;
    public static final int FLAG_Y_SHORT_VECTOR = 4;
    public static final int FLAG_REPEAT = 8;
    public static final int FLAG_THIS_X_IS_SAME = 16;
    public static final int FLAG_POSITIVE_X_SHORT_VECTOR = 16;
    public static final int FLAG_THIS_Y_IS_SAME = 32;
    public static final int FLAG_POSITIVE_Y_SHORT_VECTOR = 32;
    public static final int FLAG_RESERVED_1 = 64;
    public static final int FLAG_RESERVED_2 = 128;
    public static final int COMPONENT_FLAG_ARG_1_AND_2_ARE_WORDS = 1;
    public static final int COMPONENT_FLAG_ARGS_ARE_XY_VALUES = 2;
    public static final int COMPONENT_FLAG_ROUND_XY_TO_GRID = 4;
    public static final int COMPONENT_FLAG_WE_HAVE_A_SCALE = 8;
    public static final int COMPONENT_FLAG_OBSOLETE = 16;
    public static final int COMPONENT_FLAG_MORE_COMPONENTS = 32;
    public static final int COMPONENT_FLAG_WE_HAVE_AN_X_AND_Y_SCALE = 64;
    public static final int COMPONENT_FLAG_WE_HAVE_A_TWO_BY_TWO = 128;
    public static final int COMPONENT_FLAG_WE_HAVE_INSTRUCTIONS = 256;
    public static final int COMPONENT_FLAG_USE_MY_METRICS = 512;
    public static final int COMPONENT_FLAG_OVERLAP_COMPOUND = 1024;
    public int numberOfContours = 0;
    public int xMin = 0;
    public int yMin = 0;
    public int xMax = 0;
    public int yMax = 0;
    public int[] endPointsOfContours = new int[0];
    public int[] instructions = new int[0];
    public int[] flags = new int[0];
    public int[] xCoordinates = new int[0];
    public int[] yCoordinates = new int[0];
    public int numberOfComponents = 0;
    public int[] componentFlags = new int[0];
    public int[] componentGlyphIndex = new int[0];
    public int[] componentArgument1 = new int[0];
    public int[] componentArgument2 = new int[0];
    public double[] componentTransformA = new double[0];
    public double[] componentTransformB = new double[0];
    public double[] componentTransformC = new double[0];
    public double[] componentTransformD = new double[0];

    public void compile(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.numberOfContours);
        dataOutputStream.writeShort(this.xMin);
        dataOutputStream.writeShort(this.yMin);
        dataOutputStream.writeShort(this.xMax);
        dataOutputStream.writeShort(this.yMax);
        if (this.numberOfContours >= 0) {
            int n;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.numberOfContours; ++n2) {
                n3 = this.endPointsOfContours[n2];
                dataOutputStream.writeShort(n3);
            }
            dataOutputStream.writeShort(this.instructions.length);
            for (n2 = 0; n2 < this.instructions.length; ++n2) {
                dataOutputStream.writeByte(this.instructions[n2]);
            }
            for (n2 = 0; n2 <= n3; ++n2) {
                dataOutputStream.writeByte(this.flags[n2]);
                if ((this.flags[n2] & 8) == 0) continue;
                n = 1;
                while (n2 + n <= n3 && this.flags[n2 + n] == (this.flags[n2] & 0xFFFFFFF7)) {
                    ++n;
                }
                dataOutputStream.writeByte(n - 1);
                n2 += n;
            }
            n2 = 0;
            for (n = 0; n <= n3; ++n) {
                if ((this.flags[n] & 2) != 0) {
                    dataOutputStream.writeByte(Math.abs(this.xCoordinates[n] - n2));
                    n2 = this.xCoordinates[n];
                    continue;
                }
                if ((this.flags[n] & 0x10) != 0) {
                    n2 = this.xCoordinates[n];
                    continue;
                }
                dataOutputStream.writeShort(this.xCoordinates[n] - n2);
                n2 = this.xCoordinates[n];
            }
            n = 0;
            for (int i = 0; i <= n3; ++i) {
                if ((this.flags[i] & 4) != 0) {
                    dataOutputStream.writeByte(Math.abs(this.yCoordinates[i] - n));
                    n = this.yCoordinates[i];
                    continue;
                }
                if ((this.flags[i] & 0x20) != 0) {
                    n = this.yCoordinates[i];
                    continue;
                }
                dataOutputStream.writeShort(this.yCoordinates[i] - n);
                n = this.yCoordinates[i];
            }
        } else if (this.numberOfContours == -1) {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                if (i < this.numberOfComponents - 1) {
                    int n = i;
                    this.componentFlags[n] = this.componentFlags[n] | 0x20;
                } else {
                    int n = i;
                    this.componentFlags[n] = this.componentFlags[n] & 0xFFFFFFDF;
                }
                int n = this.componentFlags[i];
                boolean bl = (n & 1) != 0;
                boolean bl2 = (n & 8) != 0;
                boolean bl3 = (n & 0x40) != 0;
                boolean bl4 = (n & 0x80) != 0;
                dataOutputStream.writeShort(n);
                dataOutputStream.writeShort(this.componentGlyphIndex[i]);
                if (bl) {
                    dataOutputStream.writeShort(this.componentArgument1[i]);
                    dataOutputStream.writeShort(this.componentArgument2[i]);
                } else {
                    dataOutputStream.writeByte(this.componentArgument1[i]);
                    dataOutputStream.writeByte(this.componentArgument2[i]);
                }
                if (bl4) {
                    dataOutputStream.writeShort((int)Math.round(this.componentTransformA[i] * 16384.0) + (this.componentTransformA[i] < 0.0 ? 32768 : 0));
                    dataOutputStream.writeShort((int)Math.round(this.componentTransformB[i] * 16384.0) + (this.componentTransformB[i] < 0.0 ? 32768 : 0));
                    dataOutputStream.writeShort((int)Math.round(this.componentTransformC[i] * 16384.0) + (this.componentTransformC[i] < 0.0 ? 32768 : 0));
                    dataOutputStream.writeShort((int)Math.round(this.componentTransformD[i] * 16384.0) + (this.componentTransformD[i] < 0.0 ? 32768 : 0));
                    continue;
                }
                if (bl3) {
                    dataOutputStream.writeShort((int)Math.round(this.componentTransformA[i] * 16384.0) + (this.componentTransformA[i] < 0.0 ? 32768 : 0));
                    dataOutputStream.writeShort((int)Math.round(this.componentTransformD[i] * 16384.0) + (this.componentTransformD[i] < 0.0 ? 32768 : 0));
                    continue;
                }
                if (!bl2) continue;
                dataOutputStream.writeShort((int)Math.round(this.componentTransformA[i] * 16384.0) + (this.componentTransformA[i] < 0.0 ? 32768 : 0));
            }
        } else {
            throw new IllegalStateException("Unknown glyph format.");
        }
    }

    public void decompile(DataInputStream dataInputStream) throws IOException {
        this.numberOfContours = dataInputStream.readShort();
        this.xMin = dataInputStream.readShort();
        this.yMin = dataInputStream.readShort();
        this.xMax = dataInputStream.readShort();
        this.yMax = dataInputStream.readShort();
        if (this.numberOfContours >= 0) {
            int n;
            int n2;
            int n3;
            this.endPointsOfContours = new int[this.numberOfContours];
            int n4 = 0;
            for (n3 = 0; n3 < this.numberOfContours; ++n3) {
                this.endPointsOfContours[n3] = n4 = dataInputStream.readUnsignedShort();
            }
            this.instructions = new int[dataInputStream.readUnsignedShort()];
            for (n3 = 0; n3 < this.instructions.length; ++n3) {
                this.instructions[n3] = dataInputStream.readUnsignedByte();
            }
            this.flags = new int[n4 + 1];
            for (n3 = 0; n3 <= n4; ++n3) {
                this.flags[n3] = dataInputStream.readUnsignedByte();
                if ((this.flags[n3] & 8) == 0) continue;
                n2 = dataInputStream.readUnsignedByte();
                for (n = 1; n <= n2; ++n) {
                    this.flags[n3 + n] = this.flags[n3] & 0xFFFFFFF7;
                }
                n3 += n2;
            }
            this.xCoordinates = new int[n4 + 1];
            n3 = 0;
            for (n2 = 0; n2 <= n4; ++n2) {
                if ((this.flags[n2] & 2) != 0) {
                    n = (this.flags[n2] & 0x10) != 0 ? 1 : -1;
                    this.xCoordinates[n2] = n3 + n * dataInputStream.readUnsignedByte();
                    n3 = this.xCoordinates[n2];
                    continue;
                }
                if ((this.flags[n2] & 0x10) != 0) {
                    this.xCoordinates[n2] = n3;
                    continue;
                }
                this.xCoordinates[n2] = n3 + dataInputStream.readShort();
                n3 = this.xCoordinates[n2];
            }
            this.yCoordinates = new int[n4 + 1];
            n2 = 0;
            for (n = 0; n <= n4; ++n) {
                if ((this.flags[n] & 4) != 0) {
                    int n5 = (this.flags[n] & 0x20) != 0 ? 1 : -1;
                    this.yCoordinates[n] = n2 + n5 * dataInputStream.readUnsignedByte();
                    n2 = this.yCoordinates[n];
                    continue;
                }
                if ((this.flags[n] & 0x20) != 0) {
                    this.yCoordinates[n] = n2;
                    continue;
                }
                this.yCoordinates[n] = n2 + dataInputStream.readShort();
                n2 = this.yCoordinates[n];
            }
        } else if (this.numberOfContours == -1) {
            int n;
            boolean bl;
            this.numberOfComponents = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            ArrayList<Double> arrayList5 = new ArrayList<Double>();
            ArrayList<Double> arrayList6 = new ArrayList<Double>();
            ArrayList<Double> arrayList7 = new ArrayList<Double>();
            ArrayList<Double> arrayList8 = new ArrayList<Double>();
            do {
                double d;
                double d2;
                double d3;
                short s;
                double d4;
                short s2;
                boolean bl2 = ((n = dataInputStream.readUnsignedShort()) & 1) != 0;
                boolean bl3 = (n & 2) != 0;
                boolean bl4 = (n & 8) != 0;
                boolean bl5 = (n & 0x40) != 0;
                boolean bl6 = (n & 0x80) != 0;
                bl = (n & 0x20) != 0;
                ++this.numberOfComponents;
                arrayList.add(n);
                arrayList2.add(dataInputStream.readUnsignedShort());
                if (bl2) {
                    if (bl3) {
                        arrayList3.add(Integer.valueOf(dataInputStream.readShort()));
                        arrayList4.add(Integer.valueOf(dataInputStream.readShort()));
                    } else {
                        arrayList3.add(dataInputStream.readUnsignedShort());
                        arrayList4.add(dataInputStream.readUnsignedShort());
                    }
                } else if (bl3) {
                    arrayList3.add(Integer.valueOf(dataInputStream.readByte()));
                    arrayList4.add(Integer.valueOf(dataInputStream.readByte()));
                } else {
                    arrayList3.add(dataInputStream.readUnsignedByte());
                    arrayList4.add(dataInputStream.readUnsignedByte());
                }
                if (bl6) {
                    s2 = dataInputStream.readShort();
                    d4 = (double)(Math.signum(s2) * (float)(s2 & Short.MAX_VALUE)) / 16384.0;
                    s = dataInputStream.readShort();
                    d3 = (double)(Math.signum(s) * (float)(s & Short.MAX_VALUE)) / 16384.0;
                    short s3 = dataInputStream.readShort();
                    d2 = (double)(Math.signum(s3) * (float)(s3 & Short.MAX_VALUE)) / 16384.0;
                    short s4 = dataInputStream.readShort();
                    d = (double)(Math.signum(s4) * (float)(s4 & Short.MAX_VALUE)) / 16384.0;
                } else if (bl5) {
                    s2 = dataInputStream.readShort();
                    d4 = (double)(Math.signum(s2) * (float)(s2 & Short.MAX_VALUE)) / 16384.0;
                    d3 = 0.0;
                    d2 = 0.0;
                    s = dataInputStream.readShort();
                    d = (double)(Math.signum(s) * (float)(s & Short.MAX_VALUE)) / 16384.0;
                } else if (bl4) {
                    s2 = dataInputStream.readShort();
                    d4 = (double)(Math.signum(s2) * (float)(s2 & Short.MAX_VALUE)) / 16384.0;
                    d3 = 0.0;
                    d2 = 0.0;
                    d = d4;
                } else {
                    d4 = 1.0;
                    d3 = 0.0;
                    d2 = 0.0;
                    d = 1.0;
                }
                arrayList5.add(d4);
                arrayList6.add(d3);
                arrayList7.add(d2);
                arrayList8.add(d);
            } while (bl);
            this.componentFlags = new int[this.numberOfComponents];
            this.componentGlyphIndex = new int[this.numberOfComponents];
            this.componentArgument1 = new int[this.numberOfComponents];
            this.componentArgument2 = new int[this.numberOfComponents];
            this.componentTransformA = new double[this.numberOfComponents];
            this.componentTransformB = new double[this.numberOfComponents];
            this.componentTransformC = new double[this.numberOfComponents];
            this.componentTransformD = new double[this.numberOfComponents];
            for (n = 0; n < this.numberOfComponents; ++n) {
                this.componentFlags[n] = (Integer)arrayList.get(n);
                this.componentGlyphIndex[n] = (Integer)arrayList2.get(n);
                this.componentArgument1[n] = (Integer)arrayList3.get(n);
                this.componentArgument2[n] = (Integer)arrayList4.get(n);
                this.componentTransformA[n] = (Double)arrayList5.get(n);
                this.componentTransformB[n] = (Double)arrayList6.get(n);
                this.componentTransformC[n] = (Double)arrayList7.get(n);
                this.componentTransformD[n] = (Double)arrayList8.get(n);
            }
        } else {
            throw new IllegalStateException("Unknown glyph format.");
        }
    }
}

