/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.ListBasedTable;
import com.kreative.bitsnpicas.truetype.NameTableEntry;
import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameTable
extends ListBasedTable<NameTableEntry> {
    public static final int FORMAT_DEFAULT = 0;
    public int format = 0;
    private static final Comparator<NameTableEntryInfo> SORT_BY_NAME_ID = new Comparator<NameTableEntryInfo>(){

        @Override
        public int compare(NameTableEntryInfo nameTableEntryInfo, NameTableEntryInfo nameTableEntryInfo2) {
            return nameTableEntryInfo.entry.compareTo(nameTableEntryInfo2.entry);
        }
    };
    private static final Comparator<NameTableEntryInfo> SORT_BY_LOCATION = new Comparator<NameTableEntryInfo>(){

        @Override
        public int compare(NameTableEntryInfo nameTableEntryInfo, NameTableEntryInfo nameTableEntryInfo2) {
            return nameTableEntryInfo.location - nameTableEntryInfo2.location;
        }
    };

    @Override
    public String tableName() {
        return "name";
    }

    @Override
    public String[] dependencyNames() {
        return new String[0];
    }

    @Override
    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        dataOutputStream.writeShort(this.format);
        dataOutputStream.writeShort(this.size());
        dataOutputStream.writeShort(6 + this.size() * 12);
        ArrayList<NameTableEntryInfo> arrayList = new ArrayList<NameTableEntryInfo>();
        int n = 0;
        for (NameTableEntry object : this) {
            NameTableEntryInfo nameTableEntryInfo = new NameTableEntryInfo();
            nameTableEntryInfo.entry = object;
            nameTableEntryInfo.location = n;
            arrayList.add(nameTableEntryInfo);
            n += object.nameData.length;
            if (object.padding <= 0 || object.padding > 4) continue;
            n += object.padding;
        }
        Collections.sort(arrayList, SORT_BY_NAME_ID);
        for (NameTableEntryInfo nameTableEntryInfo : arrayList) {
            dataOutputStream.writeShort(((NameTableEntryInfo)nameTableEntryInfo).entry.platformID);
            dataOutputStream.writeShort(((NameTableEntryInfo)nameTableEntryInfo).entry.platformSpecificID);
            dataOutputStream.writeShort(((NameTableEntryInfo)nameTableEntryInfo).entry.languageID);
            dataOutputStream.writeShort(((NameTableEntryInfo)nameTableEntryInfo).entry.nameID);
            dataOutputStream.writeShort(((NameTableEntryInfo)nameTableEntryInfo).entry.nameData.length);
            dataOutputStream.writeShort(nameTableEntryInfo.location);
        }
        Collections.sort(arrayList, SORT_BY_LOCATION);
        for (NameTableEntryInfo nameTableEntryInfo : arrayList) {
            dataOutputStream.write(((NameTableEntryInfo)nameTableEntryInfo).entry.nameData);
            if (((NameTableEntryInfo)nameTableEntryInfo).entry.padding <= 0 || ((NameTableEntryInfo)nameTableEntryInfo).entry.padding > 4) continue;
            dataOutputStream.write(new byte[((NameTableEntryInfo)nameTableEntryInfo).entry.padding]);
        }
    }

    @Override
    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        NameTableEntryInfo nameTableEntryInfo2;
        this.format = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readUnsignedShort();
        ArrayList<NameTableEntryInfo> arrayList = new ArrayList<NameTableEntryInfo>();
        int n4 = 0;
        while (n4 < n2) {
            nameTableEntryInfo2 = new NameTableEntryInfo();
            nameTableEntryInfo2.entry = new NameTableEntry();
            ((NameTableEntryInfo)nameTableEntryInfo2).entry.index = n4++;
            ((NameTableEntryInfo)nameTableEntryInfo2).entry.platformID = dataInputStream.readUnsignedShort();
            ((NameTableEntryInfo)nameTableEntryInfo2).entry.platformSpecificID = dataInputStream.readUnsignedShort();
            ((NameTableEntryInfo)nameTableEntryInfo2).entry.languageID = dataInputStream.readUnsignedShort();
            ((NameTableEntryInfo)nameTableEntryInfo2).entry.nameID = dataInputStream.readUnsignedShort();
            ((NameTableEntryInfo)nameTableEntryInfo2).entry.nameData = new byte[dataInputStream.readUnsignedShort()];
            nameTableEntryInfo2.location = n3 + dataInputStream.readUnsignedShort();
            arrayList.add(nameTableEntryInfo2);
        }
        for (NameTableEntryInfo nameTableEntryInfo2 : arrayList) {
            dataInputStream.reset();
            dataInputStream.skipBytes(nameTableEntryInfo2.location);
            dataInputStream.readFully(((NameTableEntryInfo)nameTableEntryInfo2).entry.nameData);
        }
        Collections.sort(arrayList, SORT_BY_LOCATION);
        for (int i = 0; i < n2; ++i) {
            nameTableEntryInfo2 = (NameTableEntryInfo)arrayList.get(i);
            int n5 = i + 1 < n2 ? ((NameTableEntryInfo)arrayList.get(i + 1)).location : n;
            ((NameTableEntryInfo)nameTableEntryInfo2).entry.padding = n5 - nameTableEntryInfo2.location - ((NameTableEntryInfo)nameTableEntryInfo2).entry.nameData.length;
        }
        this.clear();
        for (NameTableEntryInfo nameTableEntryInfo2 : arrayList) {
            this.add(nameTableEntryInfo2.entry);
        }
    }

    private static final class NameTableEntryInfo {
        private NameTableEntry entry;
        private int location;

        private NameTableEntryInfo() {
        }
    }
}

