/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.data;

import com.kreative.unicode.data.UnicodeUtils;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphList
extends AbstractList<Integer>
implements Comparable<GlyphList> {
    private final int[] codePoints;
    private final String name;
    private final Set<String> aliases;

    public GlyphList(int[] nArray, String string) {
        this.codePoints = nArray;
        this.name = string;
        this.aliases = Collections.emptySet();
    }

    public GlyphList(int[] nArray, String string, Set<String> set) {
        this.codePoints = nArray;
        this.name = string;
        this.aliases = set;
    }

    @Override
    public int size() {
        return this.codePoints.length;
    }

    @Override
    public Integer get(int n) {
        return this.codePoints[n];
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    @Override
    public int compareTo(GlyphList glyphList) {
        return UnicodeUtils.naturalCompare(this.name, glyphList.name);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof GlyphList) {
            GlyphList glyphList = (GlyphList)object;
            return Arrays.equals(this.codePoints, glyphList.codePoints) && this.name.equals(glyphList.name) && this.aliases.equals(glyphList.aliases);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.codePoints) + this.name.hashCode() + this.aliases.hashCode();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

