/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttflib;

import com.kreative.unicode.ttflib.PuaaEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PuaaTable {
    private SortedMap<String, List<PuaaEntry>> entries;

    public PuaaTable(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public PuaaTable(byte[] byArray) throws IOException {
        this.read(byArray);
    }

    private void read(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        this.read(byteArrayOutputStream.toByteArray());
    }

    private void read(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.readData(dataInputStream);
        dataInputStream.close();
        byteArrayInputStream.close();
    }

    private void readData(DataInputStream dataInputStream) throws IOException {
        int n;
        this.entries = new TreeMap<String, List<PuaaEntry>>();
        dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = dataInputStream.readInt();
            nArray2[n] = dataInputStream.readInt();
        }
        for (n = 0; n < n2; ++n) {
            String string = PuaaEntry.readString(dataInputStream, 0, nArray[n]);
            List<PuaaEntry> list = PuaaTable.readEntryList(dataInputStream, 0, nArray2[n]);
            this.entries.put(string, list);
        }
        this.entries = Collections.unmodifiableSortedMap(this.entries);
    }

    public Set<String> getProperties() {
        return this.entries.keySet();
    }

    public List<PuaaEntry> getPropertyEntries(String string) {
        return (List)this.entries.get(string);
    }

    public Map<Integer, String> getPropertyMap(String string) {
        return PuaaTable.mapFromEntries((List)this.entries.get(string));
    }

    public SortedMap<Integer, String> getPropertySortedMap(String string) {
        return PuaaTable.sortedMapFromEntries((List)this.entries.get(string));
    }

    public List<PuaaEntry> getPropertyRuns(String string) {
        return PuaaTable.runsFromEntries((List)this.entries.get(string));
    }

    static List<PuaaEntry> readEntryList(DataInputStream dataInputStream, int n, int n2) throws IOException {
        if (n2 > 0) {
            int n3;
            dataInputStream.reset();
            dataInputStream.skipBytes(n + n2);
            int n4 = dataInputStream.readUnsignedShort();
            PuaaEntry[] puaaEntryArray = new PuaaEntry[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                puaaEntryArray[n3] = new PuaaEntry();
            }
            for (n3 = 0; n3 < n4; ++n3) {
                puaaEntryArray[n3].readHead(dataInputStream);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                puaaEntryArray[n3].readBody(dataInputStream, n);
            }
            return Collections.unmodifiableList(Arrays.asList(puaaEntryArray));
        }
        return null;
    }

    static Map<Integer, String> mapFromEntries(List<PuaaEntry> list) {
        if (list == null) {
            return null;
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        PuaaTable.putEntriesIntoMap(list, hashMap);
        return Collections.unmodifiableMap(hashMap);
    }

    static SortedMap<Integer, String> sortedMapFromEntries(List<PuaaEntry> list) {
        if (list == null) {
            return null;
        }
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        PuaaTable.putEntriesIntoMap(list, treeMap);
        return Collections.unmodifiableSortedMap(treeMap);
    }

    static void putEntriesIntoMap(List<PuaaEntry> list, Map<Integer, String> map) {
        for (PuaaEntry puaaEntry : list) {
            int n = puaaEntry.getFirstCodePoint();
            int n2 = puaaEntry.getLastCodePoint();
            for (int i = n; i <= n2; ++i) {
                String string = map.get(i);
                String string2 = puaaEntry.getPropertyString(i);
                map.put(i, string == null ? string2 : string + string2);
            }
        }
    }

    static List<PuaaEntry> runsFromEntries(List<PuaaEntry> list) {
        if (list == null) {
            return null;
        }
        SortedMap<Integer, String> sortedMap = PuaaTable.sortedMapFromEntries(list);
        ArrayList<PuaaEntry> arrayList = new ArrayList<PuaaEntry>();
        PuaaEntry puaaEntry = null;
        for (Map.Entry<Integer, String> entry : sortedMap.entrySet()) {
            if (puaaEntry != null && puaaEntry.extendData(entry.getKey(), entry.getValue())) continue;
            puaaEntry = new PuaaEntry();
            puaaEntry.setData(entry.getKey(), entry.getValue());
            arrayList.add(puaaEntry);
        }
        return Collections.unmodifiableList(arrayList);
    }
}

