{
"/* COMPATIBILITY \n"
"   - HLSL compilers\n"
"   - Cg   compilers\n"
"*/\n"
"\n"
"void main_vertex\n"
"(\n"
"	float4 position	: POSITION,\n"
"	float4 color	: COLOR,\n"
"	float2 texCoord : TEXCOORD0,\n"
"\n"
"    uniform float4x4 modelViewProj,\n"
"\n"
"	out float4 oPosition : POSITION,\n"
"	out float4 oColor    : COLOR,\n"
"	out float2 otexCoord : TEXCOORD\n"
")\n"
"{\n"
"	oPosition = mul(modelViewProj, position);\n"
"	oColor = color;\n"
"	otexCoord = texCoord;\n"
"}\n"
"\n"
"struct output \n"
"{\n"
"  float4 color    : COLOR;\n"
"};\n"
"\n"
"struct input\n"
"{\n"
"  float2 video_size;\n"
"  float2 texture_size;\n"
"  float2 output_size;\n"
"  float  frame_count;\n"
"  float  frame_direction;\n"
"  float frame_rotation;\n"
"};\n"
"\n"
"\n"
"output main_fragment(float2 texCoord : TEXCOORD0, uniform sampler2D decal : TEXUNIT0, uniform input IN) \n"
"{\n"
"   output OUT;\n"
"   OUT.color = tex2D(decal, texCoord);\n"
"   return OUT;\n"
"}\n"
"\n"
},
