import yoda

q2_edges = [ 150., 200., 270., 400., 700., 5000., 15000. ]
pt_edges = [ 7., 11., 18., 30., 50. ]

def patch(path, ao):

    if 'd07-x01-y03' not in path:
        return ao
    bindex = 0
    aos = [ ao ]
    for idx, q2 in enumerate(q2_edges[:-1]):
        aonew = yoda.BinnedEstimate1D(pt_edges, path.replace('y03', f'y{idx+10}'))
        aonew.setAnnotation('IsRef', 1)
        for bnew in aonew.bins():
            bold = ao.binAt(bindex)
            bw = bnew.xWidth()
            newval = bold.val()
            bnew.setVal(newval/bw)
            for src in bold.sources():
                dn, up = bold.err(src)
                bnew.setErr([dn/bw, up/bw], src)
            bindex += 1
        aos.append(aonew)
    return aos

