/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.LocalVolTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;

public class LocalConstantVol
extends LocalVolTermStructure {
    private Handle<Quote> volatility_;
    private DayCounter dayCounter_;

    public LocalConstantVol(Date referenceDate, double volatility, DayCounter dayCounter) {
        super(referenceDate);
        this.volatility_ = new Handle<SimpleQuote>(new SimpleQuote(volatility));
        this.dayCounter_ = dayCounter;
    }

    public LocalConstantVol(Date referenceDate, Handle<Quote> volatility, DayCounter dayCounter) {
        super(referenceDate);
        this.volatility_ = volatility;
        this.dayCounter_ = dayCounter;
        this.volatility_.addObserver(this);
    }

    public LocalConstantVol(int settlementDays, Calendar cal, double volatility, DayCounter dayCounter) {
        super(settlementDays, (Calendar)new NullCalendar());
        this.volatility_ = new Handle<SimpleQuote>(new SimpleQuote(volatility));
        this.dayCounter_ = dayCounter;
    }

    public LocalConstantVol(int settlementDays, Calendar cal, Handle<Quote> volatility, DayCounter dayCounter) {
        super(settlementDays, (Calendar)new NullCalendar());
        this.volatility_ = volatility;
        this.dayCounter_ = dayCounter;
        this.volatility_.addObserver(this);
    }

    @Override
    public final DayCounter dayCounter() {
        return this.dayCounter_;
    }

    @Override
    public final Date maxDate() {
        return DateFactory.getFactory().getMaxDate();
    }

    @Override
    public final double minStrike() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public final double maxStrike() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected final double localVolImpl(double maturity, double strike) {
        return this.volatility_.getLink().evaluate();
    }
}

