/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import java.util.Arrays;
import org.jquantlib.math.interpolations.AbstractInterpolation;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.Interpolator;

public class BackwardFlatInterpolation
extends AbstractInterpolation {
    private double[] vp;

    private BackwardFlatInterpolation() {
    }

    public static Interpolator getInterpolator() {
        BackwardFlatInterpolation backwardFlatInterpolation = new BackwardFlatInterpolation();
        return new BackwardFlarInterpolationImpl(backwardFlatInterpolation);
    }

    @Override
    protected double primitiveImpl(double x) {
        int i = this.locate(x);
        double dx = x - this.vx[i];
        return this.vp[i] + dx * this.vy[i + 1];
    }

    @Override
    protected double derivativeImpl(double x) {
        return 0.0;
    }

    @Override
    protected double secondDerivativeImpl(double x) {
        return 0.0;
    }

    @Override
    @Deprecated
    public void update() {
        this.reload();
    }

    @Override
    public void reload() {
        super.reload();
        this.vp = new double[this.vx.length];
        this.vp[0] = 0.0;
        for (int i = 1; i < this.vx.length; ++i) {
            double dx = this.vx[i] - this.vx[i - 1];
            this.vp[i] = this.vp[i - 1] + dx * this.vy[i];
        }
    }

    @Override
    protected double evaluateImpl(double x) {
        if (x <= this.vx[0]) {
            return this.vy[0];
        }
        int i = this.locate(x);
        if (x == this.vx[i]) {
            return this.vy[i];
        }
        return this.vy[i + 1];
    }

    private static class BackwardFlarInterpolationImpl
    implements Interpolator {
        private BackwardFlatInterpolation delegate;

        public BackwardFlarInterpolationImpl(BackwardFlatInterpolation delegate) {
            this.delegate = delegate;
        }

        @Override
        public final Interpolation interpolate(double[] x, double[] y) {
            return this.interpolate(x.length, x, y);
        }

        @Override
        public final Interpolation interpolate(int size, double[] x, double[] y) {
            this.delegate.vx = Arrays.copyOfRange(x, 0, size);
            this.delegate.vy = Arrays.copyOfRange(y, 0, size);
            this.delegate.reload();
            return this.delegate;
        }

        @Override
        public final boolean isGlobal() {
            return false;
        }
    }
}

