/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib;

import java.util.prefs.Preferences;
import org.jquantlib.Settings;

public class Configuration {
    private static volatile Configuration systemConfiguration = null;
    private static boolean allowUserConfigurations = false;
    private boolean multipleSettings = false;
    private Settings globalSettings = null;
    private Preferences preferences = null;
    private static boolean defaultExtraSafefyChecks = true;
    private static boolean defaultEnforcesTodaysHistoricFixings = false;
    private boolean extraSafetyChecks;
    private boolean enforcesTodaysHistoricFixings;

    private Configuration(Preferences prefs) {
        this.preferences = prefs;
        if (prefs != null) {
            this.extraSafetyChecks = prefs.getBoolean("ExtraSafetyChecks", defaultExtraSafefyChecks);
            this.enforcesTodaysHistoricFixings = prefs.getBoolean("EnforcesTodaysHistoricFixings", defaultEnforcesTodaysHistoricFixings);
        }
        this.globalSettings = new Settings(prefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getSystemConfiguration(Preferences prefs) {
        if (systemConfiguration != null) return systemConfiguration;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (systemConfiguration != null) return systemConfiguration;
            systemConfiguration = new Configuration(prefs);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return systemConfiguration;
        }
    }

    public static Configuration newConfiguration(Preferences prefs) {
        if (allowUserConfigurations) {
            return new Configuration(prefs);
        }
        return null;
    }

    public static void enableUserConfigurations() {
        allowUserConfigurations = true;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void enableMultipleSettings() {
        this.multipleSettings = true;
    }

    public Settings getGlobalSettings() {
        return this.globalSettings;
    }

    public Settings newSettings() {
        if (this.multipleSettings) {
            return new Settings(this.preferences);
        }
        return null;
    }

    public boolean isExtraSafetyChecks() {
        return this.extraSafetyChecks;
    }

    public boolean isEnforcesTodaysHistoricFixings() {
        return this.enforcesTodaysHistoricFixings;
    }
}

