/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.distributions.Derivative;
import org.jquantlib.math.solvers1D.NewtonSafe;

public class Newton
extends AbstractSolver1D<Derivative> {
    @Override
    protected double solveImpl(Derivative f, double xAccuracy) {
        double froot = f.evaluate(this.root_);
        double dfroot = f.derivative(this.root_);
        ++this.evaluationNumber_;
        while (this.evaluationNumber_ <= this.getMaxEvaluations()) {
            double dx = froot / dfroot;
            this.root_ -= dx;
            if ((this.xMin_ - this.root_) * (this.root_ - this.xMax_) < 0.0) {
                NewtonSafe s = new NewtonSafe();
                s.setMaxEvaluations(this.getMaxEvaluations() - this.evaluationNumber_);
                return s.solve(f, xAccuracy, this.root_ + dx, this.xMin_, this.xMax_);
            }
            if (Math.abs(dx) < xAccuracy) {
                return this.root_;
            }
            froot = f.evaluate(this.root_);
            dfroot = f.derivative(this.root_);
            ++this.evaluationNumber_;
        }
        throw new ArithmeticException("maximum number of function evaluations (" + this.getMaxEvaluations() + ") exceeded");
    }
}

