/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.xml;

public final class XMLEncode {
    private static final int AMP_LEN = 4;
    private static final int APOS_QUOT_LEN = 5;
    private static final int LTGT_LEN = 3;
    private static final String APOS = "&apos;";
    private static final String QUOT = "&quot;";
    private static final String GREATER = "&gt;";
    private static final String LESS = "&lt;";
    private static final String AMP = "&amp;";
    private static final int CDATA_BLOCK_THRESHOLD_LENGTH = 12;
    private static final char DEFAULT_QUOTE_CHAR = '\"';

    private XMLEncode() {
    }

    public static boolean isWhiteSpace(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String encodeForAttribute(String text, char quoteChar) {
        if (text == null) {
            return null;
        }
        return XMLEncode.encodeAsPCDATA(text, true, quoteChar);
    }

    public static String encode(String text) {
        String cdata;
        if (text == null) {
            return null;
        }
        if (!XMLEncode.needsEncoding(text)) {
            return text;
        }
        if (text.length() > 12 && (cdata = XMLEncode.encodeAsCDATA(text)) != null) {
            return cdata;
        }
        return XMLEncode.encodeAsPCDATA(text);
    }

    public static String encodeAsPCDATA(String text) {
        if (text == null) {
            return null;
        }
        return XMLEncode.encodeAsPCDATA(text, false);
    }

    public static String encodeAsPCDATA(String text, boolean forAttribute) {
        return XMLEncode.encodeAsPCDATA(text, forAttribute, '\"');
    }

    public static String encodeAsPCDATA(String text, boolean forAttribute, char quoteChar) {
        if (text == null) {
            return null;
        }
        StringBuffer n = new StringBuffer(text.length() * 2);
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    n.append(AMP);
                    continue block7;
                }
                case '<': {
                    n.append(LESS);
                    continue block7;
                }
                case '>': {
                    n.append(GREATER);
                    continue block7;
                }
                case '\"': {
                    if (forAttribute) {
                        n.append(QUOT);
                        continue block7;
                    }
                    n.append(c);
                    continue block7;
                }
                case '\'': {
                    if (forAttribute) {
                        n.append(APOS);
                        continue block7;
                    }
                    n.append(c);
                    continue block7;
                }
                default: {
                    n.append(c);
                }
            }
        }
        if (forAttribute) {
            n.append(quoteChar);
            n.insert(0, quoteChar);
        }
        return n.toString();
    }

    public static String encodeAsCDATA(String text) {
        if (text == null) {
            return null;
        }
        if (XMLEncode.isCompatibleWithCDATA(text)) {
            return "<![CDATA[" + text + "]]>";
        }
        return null;
    }

    public static boolean needsEncoding(String text) {
        return XMLEncode.needsEncoding(text, false);
    }

    public static boolean needsEncoding(String data, boolean checkForAttr) {
        if (data == null) {
            return false;
        }
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c != '&' && c != '<' && c != '>' && (!checkForAttr || c != '\"' && c != '\'')) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompatibleWithCDATA(String text) {
        if (text == null) {
            return false;
        }
        return text.indexOf("]]>") == -1;
    }

    public static String decodeToCDATA(String pcdata) {
        if (pcdata == null) {
            return null;
        }
        StringBuffer n = new StringBuffer(pcdata.length());
        for (int i = 0; i < pcdata.length(); ++i) {
            char c = pcdata.charAt(i);
            int pos = 2;
            if (c == '&') {
                char c1 = XMLEncode.lookAhead(1, i, pcdata);
                char c2 = XMLEncode.lookAhead(2, i, pcdata);
                char c3 = XMLEncode.lookAhead(++pos, i, pcdata);
                char c4 = XMLEncode.lookAhead(++pos, i, pcdata);
                char c5 = XMLEncode.lookAhead(++pos, i, pcdata);
                if (c1 == 'a' && c2 == 'm' && c3 == 'p' && c4 == ';') {
                    n.append("&");
                    i += 4;
                    continue;
                }
                if (c1 == 'l' && c2 == 't' && c3 == ';') {
                    n.append("<");
                    i += 3;
                    continue;
                }
                if (c1 == 'g' && c2 == 't' && c3 == ';') {
                    n.append(">");
                    i += 3;
                    continue;
                }
                if (c1 == 'q' && c2 == 'u' && c3 == 'o' && c4 == 't' && c5 == ';') {
                    n.append("\"");
                    i += 5;
                    continue;
                }
                if (c1 == 'a' && c2 == 'p' && c3 == 'o' && c4 == 's' && c5 == ';') {
                    n.append("'");
                    i += 5;
                    continue;
                }
                n.append("&");
                continue;
            }
            n.append(c);
        }
        return n.toString();
    }

    private static char lookAhead(int la, int offset, String data) {
        try {
            return data.charAt(offset + la);
        }
        catch (StringIndexOutOfBoundsException e) {
            return '\u0000';
        }
    }
}

