/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.UnicastDiscoveryServer;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.EndpointBasedProvider;
import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.internal.Plaintext;
import com.sun.jini.jeri.internal.connection.ServerConnManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ServerSocketFactory;
import javax.security.auth.Subject;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.io.context.ClientSubject;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;

public abstract class EndpointBasedServer
extends EndpointBasedProvider
implements UnicastDiscoveryServer {
    protected EndpointBasedServer(String formatName, EndpointInternals endpointInternals) {
        super(formatName, endpointInternals);
    }

    public void checkUnicastDiscoveryConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        if (constraints == null) {
            constraints = InvocationConstraints.EMPTY;
        }
        ServerEndpoint ep = this.getServerEndpoint(null);
        EndpointBasedServer.checkIntegrity(ep.checkConstraints(constraints));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUnicastDiscovery(UnicastResponse response, Socket socket, InvocationConstraints constraints, ClientSubjectChecker checker, Collection context, ByteBuffer received, ByteBuffer sent) throws IOException {
        if (response == null || socket == null || received == null || sent == null) {
            throw new NullPointerException();
        }
        if (constraints == null) {
            constraints = InvocationConstraints.EMPTY;
        }
        ServerEndpoint ep = this.getServerEndpoint(new PrearrangedServerSocketFactory(socket));
        ServerConnManagerImpl mgr = new ServerConnManagerImpl();
        this.endpointInternals.setServerConnManager(ep, mgr);
        ListenContextImpl lc = new ListenContextImpl();
        ep.enumerateListenEndpoints(lc);
        ServerConnection conn = mgr.getServerConnection();
        try {
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());
            InboundRequestHandle handle = conn.processRequestData(in, out);
            conn.checkPermissions(handle);
            EndpointBasedServer.checkIntegrity(conn.checkConstraints(handle, constraints));
            if (checker != null) {
                checker.checkClientSubject(EndpointBasedServer.getClientSubject(conn, handle));
            }
            byte[] hash = EndpointBasedServer.calcHandshakeHash(received, sent);
            byte[] clientHash = new byte[hash.length];
            new DataInputStream(in).readFully(clientHash);
            if (!Arrays.equals(clientHash, hash)) {
                throw new DiscoveryProtocolException("handshake hash mismatch");
            }
            Plaintext.writeUnicastResponse(out, response, context);
            ((OutputStream)out).flush();
        }
        finally {
            conn.close();
            lc.getListenHandle().close();
        }
    }

    protected abstract ServerEndpoint getServerEndpoint(ServerSocketFactory var1) throws UnsupportedConstraintException;

    private static Subject getClientSubject(ServerConnection connection, InboundRequestHandle handle) {
        ArrayList ctx = new ArrayList();
        connection.populateContext(handle, ctx);
        Iterator i = ctx.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof ClientSubject)) continue;
            return ((ClientSubject)obj).getClientSubject();
        }
        return null;
    }

    private static class PrearrangedServerSocketFactory
    extends ServerSocketFactory {
        private final ServerSocket ssocket;

        PrearrangedServerSocketFactory(Socket socket) throws IOException {
            this.ssocket = new PrearrangedServerSocket(socket);
        }

        public ServerSocket createServerSocket() throws IOException {
            return this.ssocket;
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            return this.ssocket;
        }

        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return this.ssocket;
        }

        public ServerSocket createServerSocket(int port, int backlog, InetAddress addr) throws IOException {
            return this.ssocket;
        }
    }

    private static class PrearrangedServerSocket
    extends ServerSocket {
        private Socket socket;
        private boolean closed = false;

        PrearrangedServerSocket(Socket socket) throws IOException {
            this.socket = socket;
        }

        public synchronized Socket accept() throws IOException {
            if (!this.closed && this.socket != null) {
                Socket s = this.socket;
                this.socket = null;
                return s;
            }
            while (!this.closed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            throw new SocketException("socket closed");
        }

        public int getLocalPort() {
            return 1;
        }

        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.notifyAll();
            }
        }
    }

    private static class ListenContextImpl
    implements ServerEndpoint.ListenContext {
        private ServerEndpoint.ListenHandle handle = null;

        private ListenContextImpl() {
        }

        public ServerEndpoint.ListenCookie addListenEndpoint(ServerEndpoint.ListenEndpoint endpoint) throws IOException {
            this.handle = endpoint.listen(new RequestDispatcher(){

                public void dispatch(InboundRequest req) {
                    throw new AssertionError((Object)"dispatch should not occur");
                }
            });
            return this.handle.getCookie();
        }

        ServerEndpoint.ListenHandle getListenHandle() {
            return this.handle;
        }
    }

    private static class ServerConnManagerImpl
    implements ServerConnManager {
        private ServerConnection conn = null;

        ServerConnManagerImpl() {
        }

        public synchronized void handleConnection(ServerConnection conn, RequestDispatcher disp) {
            if (conn == null || disp == null) {
                throw new NullPointerException();
            }
            this.conn = conn;
            this.notifyAll();
        }

        synchronized ServerConnection getServerConnection() {
            while (this.conn == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.conn;
        }
    }
}

