/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.architecture;

import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.util.Property;
import org.osgi.framework.BundleContext;

public class PropertyDescription {
    private String m_name;
    private String m_type;
    private String m_value = null;
    private boolean m_immutable = false;

    public PropertyDescription(String name, String type, String value) {
        this.m_name = name;
        this.m_type = type;
        this.m_value = value;
    }

    public PropertyDescription(String name, String type, String value, boolean immutable) {
        this.m_name = name;
        this.m_type = type;
        this.m_value = value;
        this.m_immutable = immutable;
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean isImmutable() {
        return this.m_immutable;
    }

    public Object getObjectValue(BundleContext context) {
        Class type = null;
        try {
            type = Property.computeType(this.m_type, context);
            return Property.create(type, this.m_value);
        }
        catch (ConfigurationException e) {
            return this.m_value;
        }
    }
}

