/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Color;
import netscape.application.Font;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.ListItem;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class ListView
extends View
implements Target,
FormElement {
    ListItem protoItem;
    ListItem anchorItem;
    ListItem origSelectedItem;
    Vector items = new Vector();
    Vector selectedItems = new Vector();
    Vector dirtyItems = new Vector();
    String command;
    String doubleCommand;
    Target target;
    Color backgroundColor = Color.lightGray;
    int rowHeight = 17;
    boolean allowsMultipleSelection;
    boolean allowsEmptySelection;
    boolean tracksMouseOutsideBounds = true;
    boolean tracking;
    boolean enabled = true;
    boolean transparent = false;
    static final String PROTOITEM_KEY = "protoItem";
    static final String ANCHORITEM_KEY = "anchorItem";
    static final String ORIGSELECTED_KEY = "origSelectedItem";
    static final String ITEMS_KEY = "items";
    static final String SELECTEDITEMS_KEY = "selectedItems";
    static final String DIRTYITEMS_KEY = "dirtyItems";
    static final String COMMAND_KEY = "command";
    static final String DOUBLECOMMAND_KEY = "doubleCommand";
    static final String TARGET_KEY = "target";
    static final String BACKGROUNDCOLOR_KEY = "backgroundColor";
    static final String ROWHEIGHT_KEY = "rowHeight";
    static final String MULTSELECTION_KEY = "allowsMultipleSelection";
    static final String EMPTYSELECTION_KEY = "allowsEmptySelection";
    static final String TRACKSMOUSE_KEY = "tracksMouseOutsideBounds";
    static final String ENABLED_KEY = "enabled";
    static final String TRANSPARENT_KEY = "isTransparent";
    public static String SELECT_NEXT_ITEM = "selectNext";
    public static String SELECT_PREVIOUS_ITEM = "selectPrevious";

    public ListView() {
        this(0, 0, 0, 0);
    }

    public ListView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ListView(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this._setupKeyboard();
    }

    public void setPrototypeItem(ListItem listItem) {
        this.protoItem = listItem == null ? new ListItem() : listItem;
        if (this.protoItem.font() == null) {
            this.protoItem.setFont(Font.fontNamed("Default"));
        }
        this.protoItem.setListView(this);
    }

    public ListItem prototypeItem() {
        if (this.protoItem == null) {
            this.setPrototypeItem(null);
        }
        return this.protoItem;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean wantsAutoscrollEvents() {
        return true;
    }

    public void setAllowsMultipleSelection(boolean bl) {
        this.allowsMultipleSelection = bl;
    }

    public boolean allowsMultipleSelection() {
        return this.allowsMultipleSelection;
    }

    public void setAllowsEmptySelection(boolean bl) {
        this.allowsEmptySelection = bl;
    }

    public boolean allowsEmptySelection() {
        return this.allowsEmptySelection;
    }

    public void setTracksMouseOutsideBounds(boolean bl) {
        this.tracksMouseOutsideBounds = bl;
    }

    public boolean tracksMouseOutsideBounds() {
        return this.tracksMouseOutsideBounds;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.setDirty(true);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setRowHeight(int n) {
        if (n > 0) {
            this.rowHeight = n;
            return;
        }
        this.rowHeight = this.minItemHeight();
    }

    public int rowHeight() {
        if (this.rowHeight > 0) {
            return this.rowHeight;
        }
        this.setRowHeight(this.minItemHeight());
        return this.rowHeight;
    }

    public int minItemHeight() {
        int n = 0;
        int n2 = this.items.size();
        int n3 = 0;
        while (n3 < n2) {
            ListItem listItem = (ListItem)this.items.elementAt(n3);
            int n4 = listItem.minHeight();
            if (n4 > n) {
                n = n4;
            }
            ++n3;
        }
        return n;
    }

    public int minItemWidth() {
        int n = 0;
        int n2 = this.items.size();
        int n3 = 0;
        while (n3 < n2) {
            ListItem listItem = (ListItem)this.items.elementAt(n3);
            int n4 = listItem.minWidth();
            if (n4 > n) {
                n = n4;
            }
            ++n3;
        }
        return n;
    }

    public Size minSize() {
        return new Size(this.bounds.width, this.count() * this.rowHeight());
    }

    public ListItem itemForPoint(int n, int n2) {
        int n3 = this.items.size();
        if (this.rowHeight == 0) {
            return null;
        }
        if (n3 == 0) {
            return null;
        }
        if (!this.tracksMouseOutsideBounds && !Rect.contains(0, 0, this.width(), this.height(), n, n2)) {
            return null;
        }
        int n4 = n2 / this.rowHeight;
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 >= n3) {
            n4 = n3 - 1;
        }
        return this.itemAt(n4);
    }

    public ListItem itemAt(int n) {
        return (ListItem)this.items.elementAt(n);
    }

    public int indexOfItem(ListItem listItem) {
        return this.items.indexOf(listItem);
    }

    public Rect rectForItem(ListItem listItem) {
        if (listItem == null) {
            return null;
        }
        return this.rectForItemAt(this.items.indexOf(listItem));
    }

    public Rect rectForItemAt(int n) {
        if (n < 0 || n >= this.items.size()) {
            return null;
        }
        return new Rect(0, this.rowHeight * n, this.bounds.width, this.rowHeight);
    }

    public boolean multipleItemsSelected() {
        return this.selectedItems.size() > 1;
    }

    public int selectedIndex() {
        ListItem listItem = this.selectedItem();
        if (listItem == null) {
            return -1;
        }
        return this.items.indexOf(listItem);
    }

    public ListItem selectedItem() {
        if (this.selectedItems.size() > 0) {
            return (ListItem)this.selectedItems.elementAt(0);
        }
        return null;
    }

    public Vector selectedItems() {
        return this.selectedItems;
    }

    public int count() {
        return this.items.size();
    }

    public ListItem addItem() {
        return this.insertItemAt(this.items.size());
    }

    public ListItem addItem(ListItem listItem) {
        if (listItem.font() == null) {
            listItem.setFont(Font.defaultFont());
        }
        listItem.setListView(this);
        return this.insertItemAt(listItem, this.items.size());
    }

    public ListItem insertItemAt(ListItem listItem, int n) {
        if (listItem.font() == null) {
            listItem.setFont(Font.defaultFont());
        }
        listItem.setListView(this);
        this.items.insertElementAt(listItem, n);
        if (!this.allowsEmptySelection && this.selectedItems.isEmpty()) {
            this.selectItem(listItem);
        }
        return listItem;
    }

    public ListItem insertItemAt(int n) {
        ListItem listItem = (ListItem)this.prototypeItem().clone();
        this.items.insertElementAt(listItem, n);
        if (!this.allowsEmptySelection && this.selectedItems.isEmpty()) {
            this.selectItem(listItem);
        }
        return listItem;
    }

    public void removeItemAt(int n) {
        ListItem listItem = (ListItem)this.items.elementAt(n);
        this.items.removeElementAt(n);
        this.selectedItems.removeElement(listItem);
        if (!this.allowsEmptySelection && this.selectedItems.size() == 0 && this.items.size() > 0) {
            if (--n < 0) {
                n = 0;
            }
            this.selectItem(this.itemAt(n));
        }
    }

    public void removeItem(ListItem listItem) {
        this.removeItemAt(this.items.indexOf(listItem));
    }

    public void removeAllItems() {
        this.items.removeAllElements();
        this.selectItem(null);
    }

    public void selectItem(ListItem listItem) {
        if (listItem != null && !listItem.isEnabled()) {
            listItem = null;
        }
        if (listItem == null) {
            ListItem listItem2;
            int n = this.selectedItems.size();
            if (n > 0 && !this.allowsEmptySelection) {
                listItem2 = (ListItem)this.selectedItems.elementAt(n - 1);
                this.selectedItems.removeElementAt(n - 1);
                --n;
            } else {
                listItem2 = null;
            }
            int n2 = 0;
            while (n2 < n) {
                ListItem listItem3 = (ListItem)this.selectedItems.elementAt(n2);
                listItem3.setSelected(false);
                this.markDirty(listItem3);
                ++n2;
            }
            this.selectedItems.removeAllElements();
            if (listItem2 != null) {
                this.selectedItems.addElement(listItem2);
            }
        } else if (!this.selectedItems.contains(listItem)) {
            ListItem listItem4;
            if (!this.allowsMultipleSelection && (listItem4 = this.selectedItem()) != null) {
                listItem4.setSelected(false);
                this.selectedItems.removeElement(listItem4);
                this.markDirty(listItem4);
            }
            listItem.setSelected(true);
            this.selectedItems.addElement(listItem);
            this.markDirty(listItem);
        }
        this.drawDirtyItems();
    }

    public void selectItemAt(int n) {
        this.selectItem((ListItem)this.items.elementAt(n));
    }

    public void selectOnly(ListItem listItem) {
        boolean bl = false;
        if (!listItem.isEnabled()) {
            return;
        }
        int n = this.selectedItems.size();
        if (n == 1 && listItem == this.selectedItems.elementAt(0)) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            ListItem listItem2 = (ListItem)this.selectedItems.elementAt(n2);
            if (listItem2 != listItem) {
                listItem2.setSelected(false);
                this.markDirty(listItem2);
            } else {
                bl = true;
            }
            ++n2;
        }
        this.selectedItems.removeAllElements();
        this.selectedItems.addElement(listItem);
        if (!bl) {
            listItem.setSelected(true);
            this.markDirty(listItem);
        }
        this.drawDirtyItems();
    }

    public void deselectItem(ListItem listItem) {
        if (listItem == null || this.selectedItems.size() == 1 && !this.allowsEmptySelection) {
            return;
        }
        if (!this.items.contains(listItem) || !this.selectedItems.contains(listItem)) {
            return;
        }
        this.selectedItems.removeElement(listItem);
        listItem.setSelected(false);
        this.markDirty(listItem);
        this.drawDirtyItems();
    }

    public void scrollItemAtToVisible(int n) {
        this.scrollRectToVisible(this.rectForItemAt(n));
    }

    public void scrollItemToVisible(ListItem listItem) {
        this.scrollRectToVisible(this.rectForItem(listItem));
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return false;
        }
        this.tracking = true;
        this.origSelectedItem = this.selectedItem();
        ListItem listItem = this.itemForPoint(mouseEvent.x, mouseEvent.y);
        if (listItem == null) {
            return true;
        }
        if (this.anchorItem != listItem && mouseEvent.clickCount > 1) {
            mouseEvent.setClickCount(1);
        }
        this.selectOnly(listItem);
        this.anchorItem = listItem;
        if (mouseEvent.clickCount == 2) {
            this.sendDoubleCommand();
            return false;
        }
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.tracking) {
            return;
        }
        this.disableDrawing();
        ListItem listItem = this.itemForPoint(mouseEvent.x, mouseEvent.y);
        if (!this.tracksMouseOutsideBounds && !Rect.contains(0, 0, this.width(), this.height(), mouseEvent.x, mouseEvent.y)) {
            listItem = null;
        }
        if (!this.allowsMultipleSelection) {
            if (listItem != this.selectedItem() && (this.allowsEmptySelection || listItem != null)) {
                this.anchorItem = listItem;
                this.selectItem(listItem);
            }
        } else {
            ListItem listItem2;
            int n;
            int n2;
            int n3;
            int n4 = this.items.indexOf(this.anchorItem);
            if (n4 < (n3 = listItem != null ? this.items.indexOf(listItem) : (this.pointCompare(0, this.height(), mouseEvent.y) < 0 ? 0 : this.items.size() - 1))) {
                n2 = n4;
                n = n3;
            } else {
                n2 = n3;
                n = n4;
            }
            int n5 = this.selectedItems.size();
            while (n5-- > 0) {
                listItem2 = (ListItem)this.selectedItems.elementAt(n5);
                int n6 = this.items.indexOf(listItem2);
                if (listItem2.isSelected() && (n6 < n2 || n6 > n)) {
                    this.deselectItem(listItem2);
                    continue;
                }
                if (listItem2.isSelected() || n6 < n2 || n6 > n) continue;
                this.selectItem(listItem2);
            }
            if (n2 != -1 && n != -1) {
                n5 = n2;
                while (n5 <= n) {
                    listItem2 = (ListItem)this.items.elementAt(n5);
                    if (!listItem2.isSelected()) {
                        this.selectItem(listItem2);
                    }
                    ++n5;
                }
            }
        }
        this.reenableDrawing();
        this.autoscroll(mouseEvent);
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (mouseEvent.clickCount == 1) {
            this.sendCommand();
        }
        this.tracking = false;
    }

    private int pointCompare(int n, int n2, int n3) {
        if (n3 < n) {
            return -1;
        }
        if (n3 >= n + n2) {
            return 1;
        }
        return 0;
    }

    private int rectCompare(Rect rect, Rect rect2) {
        if (rect2.maxY() <= rect.y) {
            return -1;
        }
        if (rect2.y >= rect.maxY()) {
            return 1;
        }
        return 0;
    }

    private void autoscroll(MouseEvent mouseEvent) {
        Rect rect = Rect.newRect();
        this.computeVisibleRect(rect);
        this.drawDirtyItems();
        if (!rect.contains(mouseEvent.x, mouseEvent.y)) {
            if (mouseEvent.y < rect.y) {
                Rect rect2 = Rect.newRect(rect.x, mouseEvent.y, rect.width, this.rowHeight);
                this.scrollRectToVisible(rect2);
                Rect.returnRect(rect2);
            } else if (mouseEvent.y > rect.maxY()) {
                Rect rect3 = Rect.newRect(rect.x, mouseEvent.y - this.rowHeight, rect.width, this.rowHeight);
                this.scrollRectToVisible(rect3);
                Rect.returnRect(rect3);
            }
        }
        Rect.returnRect(rect);
    }

    private void markDirty(ListItem listItem) {
        if (this.dirtyItems.contains(listItem)) {
            return;
        }
        this.dirtyItems.addElement(listItem);
    }

    private void drawDirtyItems() {
        if (!this.canDraw()) {
            return;
        }
        int n = this.dirtyItems.size();
        if (n == 0) {
            return;
        }
        Vector vector = this.dirtyItems;
        this.dirtyItems = null;
        Rect rect = Rect.newRect(0, 0, this.bounds.width, this.rowHeight);
        int n2 = this.count();
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.items.indexOf(vector.elementAt(n3));
            if (n4 >= 0 && n4 < n2) {
                rect.y = n4 * this.rowHeight;
                rect.height = this.rowHeight;
                if (n3 < n - 1) {
                    int n5 = this.items.indexOf(vector.elementAt(n3 + 1));
                    if (n5 == n4 + 1) {
                        rect.height += this.rowHeight;
                        ++n3;
                    } else if (n5 == n4 - 1) {
                        rect.height += this.rowHeight;
                        rect.y -= this.rowHeight;
                        ++n3;
                    }
                }
                this.draw(rect);
            }
            ++n3;
        }
        Rect.returnRect(rect);
        this.dirtyItems = vector;
        this.dirtyItems.removeAllElements();
    }

    public void drawItemAt(int n) {
        Rect rect = this.rectForItemAt(n);
        this.draw(rect);
    }

    public void drawViewBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.isTransparent() && this.backgroundColor != null) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    public void drawView(Graphics graphics) {
        int n;
        if (this.dirtyItems != null) {
            this.dirtyItems.removeAllElements();
        }
        if (this.rowHeight <= 0) {
            this.drawViewBackground(graphics, 0, 0, this.bounds.width, this.bounds.height);
            return;
        }
        Rect rect = Rect.newRect(graphics.clipRect());
        int n2 = this.items.size();
        int n3 = rect.y / this.rowHeight;
        if (n3 < 0 || n3 >= n2) {
            this.drawViewBackground(graphics, 0, 0, this.bounds.width, this.bounds.height);
            Rect.returnRect(rect);
            return;
        }
        Rect rect2 = this.rectForItemAt(n3);
        boolean bl = this.rectCompare(rect, rect2) == 0;
        while (n3 < n2 && bl) {
            graphics.pushState();
            graphics.setClipRect(rect2);
            ListItem listItem = (ListItem)this.items.elementAt(n3);
            if (!this.isTransparent() && listItem.isTransparent()) {
                this.drawViewBackground(graphics, rect2.x, rect2.y, this.bounds.width, this.rowHeight);
            }
            listItem.drawInRect(graphics, rect2);
            graphics.popState();
            ++n3;
            rect2.moveBy(0, this.rowHeight);
            boolean bl2 = bl = this.rectCompare(rect, rect2) == 0;
        }
        if (bl && (n = this.bounds.height - rect2.y) > 0 && !this.isTransparent()) {
            this.drawViewBackground(graphics, rect2.x, rect2.y, this.bounds.width, n);
        }
        Rect.returnRect(rect);
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String command() {
        return this.command;
    }

    public void setDoubleCommand(String string) {
        this.doubleCommand = string;
    }

    public String doubleCommand() {
        return this.doubleCommand;
    }

    public void sendCommand() {
        if (this.target != null) {
            String string = null;
            ListItem listItem = this.selectedItem();
            if (listItem != null) {
                string = listItem.command();
            }
            if (string == null) {
                string = this.command;
            }
            this.target.performCommand(string, this);
        }
    }

    public void sendDoubleCommand() {
        if (this.target != null && this.doubleCommand != null) {
            this.target.performCommand(this.doubleCommand, this);
        }
    }

    public void performCommand(String string, Object object) {
        if (SELECT_NEXT_ITEM.equals(string)) {
            this.selectNextItem(true);
            return;
        }
        if (SELECT_PREVIOUS_ITEM.equals(string)) {
            this.selectNextItem(false);
        }
    }

    void selectNextItem(boolean bl) {
        int n = this.selectedIndex();
        int n2 = this.count();
        if (bl) {
            if (n < n2 - 1) {
                this.selectItemAt(n + 1);
                this.sendCommand();
                return;
            }
        } else if (n > 0) {
            this.selectItemAt(n - 1);
            this.sendCommand();
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.ListView", 2);
        classInfo.addField(PROTOITEM_KEY, (byte)18);
        classInfo.addField(ANCHORITEM_KEY, (byte)18);
        classInfo.addField(ORIGSELECTED_KEY, (byte)18);
        classInfo.addField(ITEMS_KEY, (byte)18);
        classInfo.addField(SELECTEDITEMS_KEY, (byte)18);
        classInfo.addField(DIRTYITEMS_KEY, (byte)18);
        classInfo.addField(COMMAND_KEY, (byte)16);
        classInfo.addField(DOUBLECOMMAND_KEY, (byte)16);
        classInfo.addField(TARGET_KEY, (byte)18);
        classInfo.addField(BACKGROUNDCOLOR_KEY, (byte)18);
        classInfo.addField(ROWHEIGHT_KEY, (byte)8);
        classInfo.addField(MULTSELECTION_KEY, (byte)0);
        classInfo.addField(EMPTYSELECTION_KEY, (byte)0);
        classInfo.addField(TRACKSMOUSE_KEY, (byte)0);
        classInfo.addField(ENABLED_KEY, (byte)0);
        classInfo.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(PROTOITEM_KEY, this.protoItem);
        encoder.encodeObject(ANCHORITEM_KEY, this.anchorItem);
        encoder.encodeObject(ORIGSELECTED_KEY, this.origSelectedItem);
        encoder.encodeObject(ITEMS_KEY, this.items);
        encoder.encodeObject(SELECTEDITEMS_KEY, this.selectedItems);
        encoder.encodeObject(DIRTYITEMS_KEY, this.dirtyItems);
        encoder.encodeString(COMMAND_KEY, this.command);
        encoder.encodeString(DOUBLECOMMAND_KEY, this.doubleCommand);
        encoder.encodeObject(TARGET_KEY, this.target);
        encoder.encodeObject(BACKGROUNDCOLOR_KEY, this.backgroundColor);
        encoder.encodeInt(ROWHEIGHT_KEY, this.rowHeight);
        encoder.encodeBoolean(MULTSELECTION_KEY, this.allowsMultipleSelection);
        encoder.encodeBoolean(EMPTYSELECTION_KEY, this.allowsEmptySelection);
        encoder.encodeBoolean(TRACKSMOUSE_KEY, this.tracksMouseOutsideBounds);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.protoItem = (ListItem)decoder.decodeObject(PROTOITEM_KEY);
        this.anchorItem = (ListItem)decoder.decodeObject(ANCHORITEM_KEY);
        this.origSelectedItem = (ListItem)decoder.decodeObject(ORIGSELECTED_KEY);
        this.items = (Vector)decoder.decodeObject(ITEMS_KEY);
        this.selectedItems = (Vector)decoder.decodeObject(SELECTEDITEMS_KEY);
        this.dirtyItems = (Vector)decoder.decodeObject(DIRTYITEMS_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
        this.doubleCommand = decoder.decodeString(DOUBLECOMMAND_KEY);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUNDCOLOR_KEY);
        this.rowHeight = decoder.decodeInt(ROWHEIGHT_KEY);
        this.allowsMultipleSelection = decoder.decodeBoolean(MULTSELECTION_KEY);
        this.allowsEmptySelection = decoder.decodeBoolean(EMPTYSELECTION_KEY);
        this.tracksMouseOutsideBounds = decoder.decodeBoolean(TRACKSMOUSE_KEY);
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        if (decoder.versionForClassName("netscape.application.ListView") > 1) {
            this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
            return;
        }
        this.transparent = false;
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        this.setCommandForKey(SELECT_NEXT_ITEM, 1005, 0);
        this.setCommandForKey(SELECT_PREVIOUS_ITEM, 1004, 0);
    }

    public boolean canBecomeSelectedView() {
        return this.isEnabled();
    }

    public String formElementText() {
        if (this.selectedItem() != null) {
            return this.selectedItem().title();
        }
        return "";
    }
}

