/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.parser;

import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.PropertyValueDescription;
import org.eclipse.equinox.ds.parser.ElementHandler;
import org.eclipse.equinox.ds.parser.ImplementationElement;
import org.eclipse.equinox.ds.parser.ParserHandler;
import org.eclipse.equinox.ds.parser.PropertiesElement;
import org.eclipse.equinox.ds.parser.PropertyElement;
import org.eclipse.equinox.ds.parser.ReferenceElement;
import org.eclipse.equinox.ds.parser.ServiceElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ComponentElement
extends ElementHandler {
    private ParserHandler parent;
    private ComponentDescription component;
    private boolean immediateSet;

    ComponentElement(ParserHandler root, Attributes attributes) {
        this.root = root;
        this.parent = root;
        this.component = new ComponentDescription(root.bundleContext);
        this.immediateSet = false;
        this.processAttributes(attributes);
        if (this.component.getName() == null) {
            root.logError("component name not specified");
        }
    }

    protected void handleAttribute(String name, String value) {
        if (name.equals("name")) {
            this.component.setName(value);
            PropertyValueDescription nameProperty = new PropertyValueDescription();
            nameProperty.setName("component.name");
            nameProperty.setValue(value);
            this.component.addPropertyDescription(nameProperty);
            return;
        }
        if (name.equals("enabled")) {
            this.component.setAutoenable(value.equalsIgnoreCase("true"));
            return;
        }
        if (name.equals("factory")) {
            this.component.setFactory(value);
            return;
        }
        if (name.equals("immediate")) {
            this.component.setImmediate(value.equalsIgnoreCase("true"));
            this.immediateSet = true;
            return;
        }
        this.root.logError("unrecognized component element attribute: " + name);
    }

    ComponentDescription getComponentDescription() {
        return this.component;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.isSCRNamespace(uri)) {
            if (localName.equals("implementation")) {
                this.root.setHandler(new ImplementationElement(this.root, this, attributes));
                return;
            }
            if (localName.equals("property")) {
                this.root.setHandler(new PropertyElement(this.root, this, attributes));
                return;
            }
            if (localName.equals("properties")) {
                this.root.setHandler(new PropertiesElement(this.root, this, attributes));
                return;
            }
            if (localName.equals("service")) {
                this.root.setHandler(new ServiceElement(this.root, this, attributes));
                return;
            }
            if (localName.equals("reference")) {
                this.root.setHandler(new ReferenceElement(this.root, this, attributes));
                return;
            }
        }
        super.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) {
        if (!this.immediateSet && this.component.getFactory() == null) {
            this.component.setImmediate(this.component.getService() == null);
        }
        if (this.component.getImplementation() == null) {
            this.root.logError("no implementation element");
        }
        if (this.root.isError()) {
            this.root.setError(false);
        } else {
            this.parent.addComponentDescription(this.component);
        }
        this.root.setHandler(this.parent);
    }

    protected String getElementName() {
        return "component";
    }
}

