/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.tracker;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.equinox.ds.tracker.BundleTrackerCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class BundleTracker
implements BundleTrackerCustomizer {
    private static final boolean DEBUG = false;
    private final BundleContext context;
    final BundleTrackerCustomizer customizer;
    private Tracked tracked;
    private volatile int trackingCount = -1;
    final int mask;

    public BundleTracker(BundleContext context, int stateMask, BundleTrackerCustomizer customizer) {
        this.context = context;
        this.mask = stateMask;
        this.customizer = customizer == null ? this : customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() {
        Bundle[] bundles;
        if (this.tracked != null) {
            return;
        }
        this.tracked = new Tracked();
        this.trackingCount = 0;
        Tracked tracked = this.tracked;
        synchronized (tracked) {
            this.context.addBundleListener((BundleListener)this.tracked);
            bundles = this.context.getBundles();
        }
        if (bundles != null) {
            int length = bundles.length;
            int i = 0;
            while (i < length) {
                Bundle bundle = bundles[i];
                int state = bundle.getState();
                if ((state & this.mask) != 0) {
                    this.tracked.track(bundle);
                }
                ++i;
            }
        }
    }

    public synchronized void close() {
        if (this.tracked == null) {
            return;
        }
        this.tracked.close();
        Bundle[] bundles = this.getBundles();
        Tracked outgoing = this.tracked;
        this.tracked = null;
        try {
            this.context.removeBundleListener((BundleListener)outgoing);
        }
        catch (IllegalStateException illegalStateException) {}
        if (bundles != null) {
            int i = 0;
            while (i < bundles.length) {
                outgoing.untrack(bundles[i]);
                ++i;
            }
        }
        this.trackingCount = -1;
    }

    public Object addingBundle(Bundle bundle) {
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, Object object) {
    }

    public void removedBundle(Bundle bundle, Object object) {
    }

    void modified() {
        ++this.trackingCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle[] getBundles() {
        Tracked s_tracked = this.tracked;
        if (s_tracked == null) {
            return null;
        }
        Tracked tracked = s_tracked;
        synchronized (tracked) {
            int length;
            block6: {
                length = s_tracked.size();
                if (length != 0) break block6;
                return null;
            }
            Bundle[] bundles = new Bundle[length];
            Enumeration keys = s_tracked.keys();
            int i = 0;
            while (i < length) {
                bundles[i] = (Bundle)keys.nextElement();
                ++i;
            }
            return bundles;
        }
    }

    class Tracked
    extends Hashtable
    implements SynchronousBundleListener {
        private static final long serialVersionUID = -4232285292477873203L;
        private List adding = new ArrayList(6);
        private volatile boolean closed = false;

        protected Tracked() {
        }

        protected void close() {
            this.closed = true;
        }

        public void bundleChanged(BundleEvent event) {
            if (this.closed) {
                return;
            }
            Bundle bundle = event.getBundle();
            int state = bundle.getState();
            if ((state & BundleTracker.this.mask) != 0) {
                this.track(bundle);
            } else {
                this.untrack(bundle);
            }
        }

        /*
         * Exception decompiling
         */
        protected void track(Bundle bundle) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [6 : 162->165)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void untrack(Bundle bundle) {
            Object object;
            Tracked tracked = this;
            synchronized (tracked) {
                if (this.adding.remove(bundle)) {
                    return;
                }
                object = this.remove(bundle);
                if (object == null) {
                    return;
                }
                BundleTracker.this.modified();
            }
            BundleTracker.this.customizer.removedBundle(bundle, object);
        }
    }
}

