/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.math.Closeness;
import org.jquantlib.math.interpolations.DefaultExtrapolator;
import org.jquantlib.math.interpolations.Interpolation2D;
import org.jquantlib.util.stdlibc.Std;

public abstract class AbstractInterpolation2D
implements Interpolation2D {
    protected double[] vx;
    protected double[] vy;
    protected double[][] mz;
    private DefaultExtrapolator delegatedExtrapolator = new DefaultExtrapolator();

    protected abstract double evaluateImpl(double var1, double var3);

    public void calculate() {
        throw new UnsupportedOperationException();
    }

    protected final void checkRange(double x, double y, boolean extrapolate) {
        if (!(extrapolate || this.allowsExtrapolation() || this.isInRange(x, y))) {
            StringBuilder sb = new StringBuilder();
            sb.append("interpolation range is [");
            sb.append(this.xMin()).append(", ").append(this.xMax());
            sb.append("] x [");
            sb.append(this.yMin()).append(", ").append(this.yMax());
            sb.append("]: extrapolation at (");
            sb.append(x).append(",").append(y);
            sb.append(") not allowed");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    @Override
    public double xMin() {
        return this.vx[0];
    }

    @Override
    public double xMax() {
        return this.vx[this.vx.length - 1];
    }

    @Override
    public double yMin() {
        return this.vy[0];
    }

    @Override
    public double yMax() {
        return this.vy[this.vy.length - 1];
    }

    @Override
    public double[] xValues() {
        return (double[])this.vx.clone();
    }

    @Override
    public double[] yValues() {
        return (double[])this.vy.clone();
    }

    @Override
    public double[][] zData() {
        return (double[][])this.mz.clone();
    }

    @Override
    public int locateX(double x) {
        if (x <= this.vx[0]) {
            return 0;
        }
        if (x > this.vx[this.vx.length - 1]) {
            return this.vx.length - 2;
        }
        return Std.upper_bound(this.vx, x) - 1;
    }

    @Override
    public int locateY(double y) {
        if (y <= this.vy[0]) {
            return 0;
        }
        if (y > this.vy[this.vy.length - 1]) {
            return this.vy.length - 2;
        }
        return Std.upper_bound(this.vy, y) - 1;
    }

    @Override
    public boolean isInRange(double x, double y) {
        boolean xIsInrange;
        double x1 = this.xMin();
        double x2 = this.xMax();
        boolean bl = xIsInrange = x >= x1 && x <= x2 || Closeness.isClose(x, x1) || Closeness.isClose(x, x2);
        if (!xIsInrange) {
            return false;
        }
        double y1 = this.yMin();
        double y2 = this.yMax();
        return y >= y1 && y <= y2 || Closeness.isClose(y, y1) || Closeness.isClose(y, y2);
    }

    @Override
    @Deprecated
    public void update() {
        this.reload();
    }

    @Override
    public void reload() {
        if (this.vx.length < 2 || this.vy.length < 2) {
            throw new IllegalArgumentException("not enough points to interpolate");
        }
        for (int i = 0; i < this.vx.length - 1; ++i) {
            if (this.vx[i] > this.vx[i + 1]) {
                throw new IllegalArgumentException("unsorted values on array X");
            }
            if (!(this.vy[i] > this.vy[i + 1])) continue;
            throw new IllegalArgumentException("unsorted values on array Y");
        }
    }

    @Override
    public double evaluate(double x, double y) {
        this.checkRange(x, y, this.allowsExtrapolation());
        return this.evaluateImpl(x, y);
    }

    @Override
    public final boolean allowsExtrapolation() {
        return this.delegatedExtrapolator.allowsExtrapolation();
    }

    @Override
    public void disableExtrapolation() {
        this.delegatedExtrapolator.disableExtrapolation();
    }

    @Override
    public void enableExtrapolation() {
        this.delegatedExtrapolator.enableExtrapolation();
    }
}

