/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.xml;

import com.infor.core.lang.GenericUtil;
import com.infor.core.xml.ValidationErrorHandler;
import com.infor.core.xml.ValidationErrorMap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public final class XsdUtil {
    private static Map<String, Schema> map = GenericUtil.newHashMap();

    private XsdUtil() {
    }

    public static ValidationErrorMap validateXMLWithSchema(String xsdFileName, String ... xmlFileNames) {
        StreamSource src = null;
        ValidationErrorHandler eh = new ValidationErrorHandler();
        String currentInputFile = null;
        Schema theSchema = null;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            theSchema = XsdUtil.getXsdSchema(schemaFactory, xsdFileName);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error loading schema: " + xsdFileName, e);
        }
        try {
            Validator v = theSchema.newValidator();
            String[] arr$ = xmlFileNames;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String fileName;
                currentInputFile = fileName = arr$[i$];
                src = XsdUtil.getXmlSource(fileName);
                eh.setFileName(fileName);
                v.reset();
                v.setErrorHandler(eh);
                v.validate(src);
            }
        }
        catch (SAXException saxe2) {
            Object saxe2 = null;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading/validating : " + currentInputFile, e);
        }
        finally {
            if (src != null) {
                try {
                    if (src.getInputStream() != null) {
                        src.getInputStream().close();
                    }
                }
                catch (IOException e2) {
                    Object e2 = null;
                }
            }
        }
        return eh.getErrorMap();
    }

    public static StreamSource getXmlSource(String docRef) throws IOException {
        if (docRef.startsWith("http")) {
            return new StreamSource(new URL(docRef).openStream());
        }
        return new StreamSource(new File(docRef));
    }

    public static Schema getXsdSchema(SchemaFactory fact, String docRef) throws SAXException {
        Schema sch = map.get(docRef);
        if (sch == null) {
            sch = fact.newSchema(new File(docRef));
            map.put(docRef, sch);
        }
        return sch;
    }
}

