/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.launch;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.launch.EquinoxFWClassLoader;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.SystemBundle;

public class Equinox
implements SystemBundle {
    private static final String implName = "org.eclipse.osgi.framework.internal.core.EquinoxSystemBundle";
    private SystemBundle impl;
    private final boolean useSeparateCL = FrameworkProperties.inUse();

    private SystemBundle createImpl() {
        try {
            Class implClazz = this.getImplClass();
            return (SystemBundle)implClazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(implName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private Class getImplClass() throws ClassNotFoundException {
        ClassLoader thisCL = this.getClass().getClassLoader();
        if (!this.useSeparateCL || !(thisCL instanceof URLClassLoader)) {
            return Class.forName(implName);
        }
        URL[] cp = ((URLClassLoader)thisCL).getURLs();
        EquinoxFWClassLoader fwCL = new EquinoxFWClassLoader(cp, thisCL);
        return fwCL.loadClass(implName);
    }

    private synchronized SystemBundle getImpl() {
        if (this.impl == null) {
            this.impl = this.createImpl();
        }
        return this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties configuration) {
        if ((this.getState() & 0x38) != 0) {
            throw new IllegalStateException("Framework is active!!");
        }
        Equinox equinox = this;
        synchronized (equinox) {
            if (this.impl != null && this.impl.getState() != 2) {
                try {
                    this.impl.stop();
                    this.impl.waitForStop(30000L);
                }
                catch (BundleException bundleException) {
                }
                catch (InterruptedException interruptedException) {}
                this.impl = null;
            }
        }
        this.getImpl().init(configuration);
    }

    public void waitForStop(long timeout) throws InterruptedException {
        this.getImpl().waitForStop(timeout);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        return this.getImpl().findEntries(path, filePattern, recurse);
    }

    public BundleContext getBundleContext() {
        return this.getImpl().getBundleContext();
    }

    public long getBundleId() {
        return this.getImpl().getBundleId();
    }

    public URL getEntry(String path) {
        return this.getImpl().getEntry(path);
    }

    public Enumeration getEntryPaths(String path) {
        return this.getImpl().getEntryPaths(path);
    }

    public Dictionary getHeaders() {
        return this.getImpl().getHeaders();
    }

    public Dictionary getHeaders(String locale) {
        return this.getImpl().getHeaders(locale);
    }

    public long getLastModified() {
        return this.getImpl().getLastModified();
    }

    public String getLocation() {
        return this.getImpl().getLocation();
    }

    public ServiceReference[] getRegisteredServices() {
        return this.getImpl().getRegisteredServices();
    }

    public URL getResource(String name) {
        return this.getImpl().getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        return this.getImpl().getResources(name);
    }

    public ServiceReference[] getServicesInUse() {
        return this.getImpl().getServicesInUse();
    }

    public int getState() {
        return this.getImpl().getState();
    }

    public String getSymbolicName() {
        return this.getImpl().getSymbolicName();
    }

    public boolean hasPermission(Object permission) {
        return this.getImpl().hasPermission(permission);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.getImpl().loadClass(name);
    }

    public void start(int options) throws BundleException {
        this.getImpl().start(options);
    }

    public void start() throws BundleException {
        this.getImpl().start();
    }

    public void stop(int options) throws BundleException {
        this.getImpl().stop(options);
    }

    public void stop() throws BundleException {
        this.getImpl().stop();
    }

    public void uninstall() throws BundleException {
        this.getImpl().uninstall();
    }

    public void update() throws BundleException {
        this.getImpl().update();
    }

    public void update(InputStream in) throws BundleException {
        this.getImpl().update(in);
    }
}

