/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.launch;

import java.net.URL;
import java.net.URLClassLoader;

class EquinoxFWClassLoader
extends URLClassLoader {
    private static final String[] DELEGATE_PARENT = new String[]{"org.osgi.", "org.eclipse.osgi.launch.", "org.eclipse.osgi.service."};
    private static final String[] SKIP_PARENT = new String[]{"org.osgi.framework.AdminPermission", "org.osgi.framework.FrameworkUtil", "org.osgi.service.condpermadmin.BundleSignerCondition"};
    private final ClassLoader parent;

    public EquinoxFWClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.parent = parent;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        boolean childFirst = this.childFirst(name);
        ClassNotFoundException cnfe = null;
        if (childFirst) {
            try {
                clazz = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                cnfe = e;
            }
        }
        if (clazz == null) {
            try {
                clazz = this.parent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null && cnfe != null) {
            throw cnfe;
        }
        if (clazz == null && !childFirst) {
            clazz = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean childFirst(String name) {
        int i = SKIP_PARENT.length - 1;
        while (i >= 0) {
            if (name.startsWith(SKIP_PARENT[i])) {
                return true;
            }
            --i;
        }
        i = DELEGATE_PARENT.length - 1;
        while (i >= 0) {
            if (name.startsWith(DELEGATE_PARENT[i])) {
                return false;
            }
            --i;
        }
        return true;
    }
}

