/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Sweden
extends DelegateCalendar {
    private static final Sweden SSE_CALENDAR = new Sweden(Market.SSE);

    private Sweden(Market market) {
        SwedenSECalendar delegate;
        switch (market) {
            case SSE: {
                delegate = new SwedenSECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Sweden getCalendar(Market market) {
        switch (market) {
            case SSE: {
                return SSE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class SwedenSECalendar
    extends WesternCalendar {
        private SwedenSECalendar() {
        }

        @Override
        public String getName() {
            return "Sweden Stock Exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            int m = date.getMonth();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || dd == em - 3 || dd == em || dd == em + 38 || dd == em + 49 || d == 1 && m == Month.JANUARY.toInteger() || d == 6 && m == Month.JANUARY.toInteger() || d == 1 && m == Month.MAY.toInteger() || w == Weekday.FRIDAY && d >= 18 && d <= 24 && m == Month.JUNE.toInteger() || d == 24 && m == Month.DECEMBER.toInteger() || d == 25 && m == Month.DECEMBER.toInteger() || d == 26 && m == Month.DECEMBER.toInteger()) && (d != 31 || m != Month.DECEMBER.toInteger());
        }
    }

    public static enum Market {
        SSE;

    }
}

