/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;
import org.jquantlib.util.Month;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateParser {
    private static final Logger logger = LoggerFactory.getLogger(DateParser.class);

    public static Date parseISO(String str) {
        if (str.length() == 10 && str.charAt(4) == '-' && str.charAt(7) == '-') {
            int year = Integer.parseInt(str.substring(0, 4));
            int month = Integer.parseInt(str.substring(5, 7));
            int day = Integer.parseInt(str.substring(8, 10));
            logger.debug(DateFactory.getFactory().getDate(day, Month.valueOf(month), year).toString());
            return DateFactory.getFactory().getDate(day, Month.valueOf(month), year);
        }
        throw new IllegalArgumentException("Invalid format " + str);
    }

    public static Date parse(String str, String fmt) {
        String[] slist = null;
        String[] flist = null;
        int d = 0;
        int m = 0;
        int y = 0;
        slist = str.split(str, 47);
        if (slist.length != (flist = str.split(fmt, 47)).length) {
            throw new IllegalArgumentException("String " + str + " didn't match with reference format " + fmt);
        }
        for (int i = 0; i < flist.length; ++i) {
            String sub = flist[i];
            if (sub.equalsIgnoreCase("dd")) {
                d = Integer.parseInt(slist[i]);
                continue;
            }
            if (sub.equalsIgnoreCase("mm")) {
                m = Integer.parseInt(slist[i]);
                continue;
            }
            if (!sub.equalsIgnoreCase("yyyy") || (y = Integer.parseInt(slist[i])) >= 100) continue;
            y += 2000;
        }
        logger.debug(DateFactory.getFactory().getDate(d, Month.valueOf(m), y).toString());
        return DateFactory.getFactory().getDate(d, Month.valueOf(m), y);
    }
}

