/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.repo.provider;

import aQute.bnd.util.dto.DTO;
import aQute.bnd.version.MavenVersion;
import aQute.lib.tag.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class MetadataParser {
    static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    static final SimpleDateFormat timestamp = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
    static final SimpleDateFormat snapshotTimestamp = new SimpleDateFormat("yyyyMMdd.HHmmss", Locale.US);

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        timestamp.setTimeZone(tz);
        snapshotTimestamp.setTimeZone(tz);
    }

    public static ProgramMetadata parseProgramMetadata(InputStream in) throws Exception {
        XMLStreamReader sr = inputFactory.createXMLStreamReader(in);
        sr.nextTag();
        sr.require(1, null, "metadata");
        return MetadataParser.programMetadata(sr);
    }

    public static RevisionMetadata parseRevisionMetadata(InputStream in) throws Exception {
        XMLStreamReader sr = inputFactory.createXMLStreamReader(in);
        sr.nextTag();
        sr.require(1, null, "metadata");
        return MetadataParser.revisionMetadata(sr);
    }

    public static RevisionMetadata parseRevisionMetadata(File metadataFile) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream in = new FileInputStream(metadataFile);){
            return MetadataParser.parseRevisionMetadata(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static RevisionMetadata revisionMetadata(XMLStreamReader sr) throws Exception {
        RevisionMetadata metadata = new RevisionMetadata();
        metadata.modelVersion = MetadataParser.getModelVersion(sr);
        while (sr.nextTag() == 1) {
            String name;
            switch (name = sr.getLocalName()) {
                case "groupId": {
                    metadata.group = MetadataParser.getText(sr);
                    break;
                }
                case "artifactId": {
                    metadata.artifact = MetadataParser.getText(sr);
                    break;
                }
                case "version": {
                    metadata.version = MetadataParser.getVersion(sr);
                    break;
                }
                case "versioning": {
                    MetadataParser.snapshots(sr, metadata);
                    break;
                }
                default: {
                    MetadataParser.skip(sr);
                }
            }
            sr.require(2, null, name);
        }
        return metadata;
    }

    private static void snapshots(XMLStreamReader sr, RevisionMetadata metadata) throws Exception {
        while (sr.nextTag() == 1) {
            String name;
            switch (name = sr.getLocalName()) {
                case "lastUpdated": {
                    metadata.lastUpdated = MetadataParser.getTimestamp(sr);
                    break;
                }
                case "snapshot": {
                    metadata.snapshot = MetadataParser.snapshot(sr);
                    break;
                }
                case "snapshotVersions": {
                    MetadataParser.snapshotVersions(sr, metadata.snapshotVersions);
                    break;
                }
                default: {
                    MetadataParser.skip(sr);
                }
            }
            sr.require(2, null, name);
        }
    }

    private static void snapshotVersions(XMLStreamReader sr, List<SnapshotVersion> snapshotVersions) throws Exception {
        while (sr.nextTag() == 1) {
            String name;
            switch (name = sr.getLocalName()) {
                case "snapshotVersion": {
                    snapshotVersions.add(MetadataParser.getSnapshotVersion(sr));
                    break;
                }
                default: {
                    MetadataParser.skip(sr);
                }
            }
            sr.require(2, null, name);
        }
    }

    private static SnapshotVersion getSnapshotVersion(XMLStreamReader sr) throws Exception {
        SnapshotVersion sv = new SnapshotVersion();
        while (sr.nextTag() == 1) {
            String name;
            switch (name = sr.getLocalName()) {
                case "classifier": {
                    sv.classifier = MetadataParser.getText(sr);
                    break;
                }
                case "extension": {
                    sv.extension = MetadataParser.getText(sr);
                    break;
                }
                case "value": {
                    sv.value = MetadataParser.getVersion(sr);
                    break;
                }
                case "updated": {
                    sv.updated = MetadataParser.getTimestamp(sr);
                    break;
                }
                default: {
                    MetadataParser.skip(sr);
                }
            }
            sr.require(2, null, name);
        }
        return sv;
    }

    private static Snapshot snapshot(XMLStreamReader sr) throws Exception {
        Snapshot snapshot = new Snapshot();
        while (sr.nextTag() == 1) {
            String name;
            switch (name = sr.getLocalName()) {
                case "timestamp": {
                    snapshot.timestamp = MetadataParser.getText(sr);
                    break;
                }
                case "buildNumber": {
                    snapshot.buildNumber = MetadataParser.getText(sr);
                    break;
                }
                default: {
                    MetadataParser.skip(sr);
                }
            }
            sr.require(2, null, name);
        }
        return snapshot;
    }

    private static ProgramMetadata programMetadata(XMLStreamReader sr) throws Exception {
        ProgramMetadata gameta = new ProgramMetadata();
        gameta.modelVersion = MetadataParser.getModelVersion(sr);
        while (sr.nextTag() == 1) {
            String name;
            switch (name = sr.getLocalName()) {
                case "groupId": {
                    gameta.group = MetadataParser.getText(sr);
                    break;
                }
                case "artifactId": {
                    gameta.artifact = MetadataParser.getText(sr);
                    break;
                }
                case "versioning": {
                    MetadataParser.versioning(sr, gameta);
                    break;
                }
                default: {
                    MetadataParser.skip(sr);
                }
            }
            sr.require(2, null, name);
        }
        return gameta;
    }

    private static void versioning(XMLStreamReader sr, ProgramMetadata gameta) throws Exception {
        while (sr.nextTag() == 1) {
            String name;
            switch (name = sr.getLocalName()) {
                case "lastUpdated": {
                    gameta.lastUpdated = MetadataParser.getTimestamp(sr);
                    break;
                }
                case "versions": {
                    MetadataParser.versions(sr, gameta.versions);
                    break;
                }
                case "latest": {
                    gameta.latest = MetadataParser.getVersion(sr);
                    break;
                }
                case "release": {
                    gameta.release = MetadataParser.getVersion(sr);
                    break;
                }
                default: {
                    MetadataParser.skip(sr);
                }
            }
            sr.require(2, null, name);
        }
    }

    private static void versions(XMLStreamReader sr, List<MavenVersion> versions) throws Exception {
        while (sr.nextTag() == 1) {
            String name;
            switch (name = sr.getLocalName()) {
                case "version": {
                    versions.add(MetadataParser.getVersion(sr));
                    break;
                }
                default: {
                    MetadataParser.skip(sr);
                }
            }
            sr.require(2, null, null);
        }
    }

    private static String getText(XMLStreamReader sr) throws Exception {
        String elementText = sr.getElementText();
        if (elementText == null) {
            return null;
        }
        return elementText.trim();
    }

    private static void skip(XMLStreamReader sr) throws Exception {
        System.out.println("Skipping " + sr.getLocalName());
        while (sr.nextTag() == 1) {
            MetadataParser.skip(sr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getTimestamp(XMLStreamReader sr) throws Exception {
        SimpleDateFormat simpleDateFormat = timestamp;
        synchronized (simpleDateFormat) {
            String date;
            block4: {
                date = MetadataParser.getText(sr);
                if (date != null) break block4;
                return 0L;
            }
            Date parse = timestamp.parse(date.trim());
            return parse.getTime();
        }
    }

    private static MavenVersion getVersion(XMLStreamReader sr) throws Exception {
        String version = MetadataParser.getText(sr);
        if (version == null) {
            return null;
        }
        return new MavenVersion(version);
    }

    private static String getModelVersion(XMLStreamReader sr) throws Exception {
        int i = 0;
        while (i < sr.getAttributeCount()) {
            String name = sr.getAttributeLocalName(i);
            if (name.equals("modelVersion")) {
                return sr.getAttributeValue(i).trim();
            }
            ++i;
        }
        return null;
    }

    public static ProgramMetadata parseProgramMetadata(File metafile) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream in = new FileInputStream(metafile);){
            return MetadataParser.parseProgramMetadata(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static class Metadata
    extends DTO {
        public String modelVersion;
        public String group;
        public String artifact;
        public long lastUpdated = System.currentTimeMillis();

        public Tag toTag() {
            Tag top = new Tag("metadata", new Object[]{"modelVersion", this.modelVersion});
            new Tag(top, "groupId", new Object[0]).addContent(this.group);
            new Tag(top, "artifactId", new Object[0]).addContent(this.artifact);
            new Tag(top, "lastUpdated", new Object[]{timestamp.format(new Date(this.lastUpdated))});
            return top;
        }

        public String toString() {
            Tag tag = this.toTag();
            return tag.toString();
        }
    }

    public static class ProgramMetadata
    extends Metadata {
        public MavenVersion latest;
        public MavenVersion release;
        public List<MavenVersion> versions = new ArrayList<MavenVersion>();

        @Override
        public Tag toTag() {
            Tag top = super.toTag();
            if (this.latest != null) {
                new Tag(top, "latest", new Object[0]).addContent(this.latest.toString());
            }
            if (this.release != null) {
                new Tag(top, "release", new Object[0]).addContent(this.release.toString());
            }
            Tag versionsTag = new Tag(top, "versions", new Object[0]);
            for (MavenVersion mv : this.versions) {
                new Tag(versionsTag, "version", new Object[0]).addContent(mv.toString());
            }
            return top;
        }
    }

    public static class RevisionMetadata
    extends Metadata {
        public MavenVersion version;
        public Snapshot snapshot = new Snapshot();
        public List<SnapshotVersion> snapshotVersions = new ArrayList<SnapshotVersion>();

        @Override
        public Tag toTag() {
            Tag top = super.toTag();
            new Tag(top, "version", new Object[]{this.version});
            Tag snapshot = new Tag(top, "snapshot", new Object[0]);
            new Tag(snapshot, "timestamp", new Object[]{this.snapshot.timestamp});
            new Tag(snapshot, "buildNumber", new Object[]{this.snapshot.buildNumber});
            new Tag(snapshot, "localCopy", new Object[]{this.snapshot.localCopy});
            Tag versioning = new Tag(top, "versioning", new Object[0]);
            Tag snapshotVersions = new Tag(versioning, "snapshotVersions", new Object[0]);
            for (SnapshotVersion sv : this.snapshotVersions) {
                Tag x = new Tag(snapshotVersions, "snapshotVersion", new Object[0]);
                new Tag(x, "extension", new Object[]{sv.extension});
                if (sv.classifier != null) {
                    new Tag(x, "classifier", new Object[]{sv.classifier});
                }
                new Tag(x, "value", new Object[]{"" + sv.value});
                new Tag(x, "updated", new Object[]{timestamp.format(new Date(sv.updated))});
            }
            return top;
        }
    }

    public static class Snapshot {
        public String timestamp;
        public String buildNumber = null;
        public boolean localCopy = false;
    }

    public static class SnapshotVersion {
        public String classifier;
        public String extension;
        public MavenVersion value;
        public long updated;
    }
}

