/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.repo.provider;

import aQute.bnd.http.HttpRequestException;
import aQute.bnd.service.url.TaggedData;
import aQute.lib.io.IO;
import aQute.maven.repo.api.Archive;
import aQute.maven.repo.api.Release;
import aQute.maven.repo.api.Revision;
import aQute.maven.repo.provider.MavenStorage;
import aQute.maven.repo.provider.MetadataParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class Releaser
implements Release {
    final List<Archive> upload = new ArrayList<Archive>();
    final MavenStorage home;
    final Revision revision;
    final MetadataParser.RevisionMetadata programMetadata = new MetadataParser.RevisionMetadata();
    boolean force;
    boolean aborted;
    private File dir;
    protected boolean localOnly;

    Releaser(MavenStorage home, Revision revision) throws Exception {
        this.home = home;
        this.revision = revision;
        this.dir = home.toLocalFile(revision.path);
        if (this.force) {
            IO.delete((File)this.dir);
        }
        if (this.dir.exists()) {
            throw new IllegalArgumentException("The target directory already exists " + this.dir);
        }
        this.dir.mkdirs();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.aborted && !this.localOnly) {
                this.uploadAll(this.upload.iterator());
                this.updateMetadata();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void updateMetadata() throws Exception, InterruptedException {
        int n = 0;
        while (true) {
            try {
                MetadataParser.ProgramMetadata metadata;
                File metafile = this.home.toLocalFile(this.revision.program.metadata(this.home.id));
                TaggedData tag = this.home.release.fetch(this.revision.program.metadata(), metafile);
                switch (tag.getState()) {
                    case NOT_FOUND: {
                        metadata = new MetadataParser.ProgramMetadata();
                        break;
                    }
                    case OTHER: {
                        throw new HttpRequestException((HttpURLConnection)tag.getConnection());
                    }
                    default: {
                        metadata = MetadataParser.parseProgramMetadata(metafile);
                    }
                }
                long lastModified = metafile.lastModified();
                if (metadata.versions.contains(this.revision.version)) {
                    if (this.force) {
                        return;
                    }
                    throw new IllegalStateException("Revision already exists on remote system " + this.revision + " " + this.home.release);
                }
                metadata.versions.add(this.revision.version);
                IO.store((Object)metadata.toString(), (File)metafile);
                this.home.release.store(metafile, this.revision.program.metadata());
                return;
            }
            catch (Exception e) {
                if (n++ > 3) {
                    throw e;
                }
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    void uploadAll(Iterator<Archive> iterator) throws Exception {
        if (!iterator.hasNext()) {
            return;
        }
        Archive archive = iterator.next();
        File f = this.home.toLocalFile(archive);
        try {
            this.home.release.store(f, archive.remotePath);
            this.uploadAll(iterator);
        }
        catch (Exception e) {
            try {
                this.home.release.delete(archive.remotePath);
            }
            catch (Exception ee) {
                throw e;
            }
        }
    }

    @Override
    public void add(Archive archive, InputStream in) throws Exception {
        try {
            archive = this.resolve(archive);
            this.home.store(archive, in);
            this.upload.add(archive);
        }
        catch (Exception e) {
            this.aborted = true;
            throw e;
        }
    }

    protected Archive resolve(Archive archive) throws Exception {
        return archive;
    }

    @Override
    public void add(Archive archive, File in) throws Exception {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fin = new FileInputStream(in);){
                this.add(archive, fin);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.aborted = true;
            throw e;
        }
    }

    @Override
    public void abort() {
        this.aborted = true;
    }

    public void force() {
        this.force = true;
    }

    @Override
    public void add(String extension, String classifier, InputStream in) throws Exception {
        Archive a = this.revision.archive(extension, classifier);
        this.add(a, in);
    }

    @Override
    public void setBuild(long timestamp, String build) {
        throw new IllegalArgumentException("This is not a snapshot release so you cannot set the timestamp");
    }

    @Override
    public void setBuild(String timestamp, String build) {
    }

    @Override
    public void setLocalOnly() {
        this.localOnly = true;
    }
}

