/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.impl;

import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerAnalog;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.gpio.event.PinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.PinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.PinEvent;
import com.pi4j.io.gpio.event.PinEventType;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.gpio.trigger.GpioTrigger;
import java.util.ArrayList;

public class GpioEventMonitorImpl
implements PinListener {
    private final GpioPinInput pin;

    public GpioEventMonitorImpl(GpioPinInput pin) {
        this.pin = pin;
    }

    @Override
    public void handlePinEvent(PinEvent event) {
        block3: {
            block4: {
                if (!this.pin.getPin().equals(event.getPin())) break block3;
                if (event.getEventType() != PinEventType.DIGITAL_STATE_CHANGE) break block4;
                PinState state = ((PinDigitalStateChangeEvent)event).getState();
                ArrayList<GpioPinListener> listeners = new ArrayList<GpioPinListener>(this.pin.getListeners());
                for (GpioPinListener listener : listeners) {
                    if (listener == null || !(listener instanceof GpioPinListenerDigital)) continue;
                    ((GpioPinListenerDigital)listener).handleGpioPinDigitalStateChangeEvent(new GpioPinDigitalStateChangeEvent(event.getSource(), (GpioPin)this.pin, state));
                }
                ArrayList<GpioTrigger> triggers = new ArrayList<GpioTrigger>(this.pin.getTriggers());
                for (GpioTrigger trigger : triggers) {
                    if (trigger == null || !trigger.hasPinState(state)) continue;
                    trigger.invoke(this.pin, state);
                }
                break block3;
            }
            if (event.getEventType() != PinEventType.ANALOG_VALUE_CHANGE) break block3;
            double value = ((PinAnalogValueChangeEvent)event).getValue();
            ArrayList<GpioPinListener> listeners = new ArrayList<GpioPinListener>(this.pin.getListeners());
            for (GpioPinListener listener : listeners) {
                if (listener == null || !(listener instanceof GpioPinListenerAnalog)) continue;
                ((GpioPinListenerAnalog)listener).handleGpioPinAnalogValueChangeEvent(new GpioPinAnalogValueChangeEvent(event.getSource(), (GpioPin)this.pin, value));
            }
        }
    }
}

