/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeReference<T> {
    private final Type[] types;
    private volatile Constructor<?> constructor;

    protected TypeReference() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new IllegalArgumentException("Class should be anonymous or extended from a generic class");
        }
        this.types = ((ParameterizedType)superclass).getActualTypeArguments();
    }

    public Type getGenericType() {
        return this.getGenericType(0);
    }

    public Type getGenericType(int n) {
        return this.types[n];
    }

    public Class<?> getGenericParameterClass() {
        return this.getGenericParameterClass(0);
    }

    public Class<?> getGenericParameterClass(int n) {
        Class clazz;
        if (n >= this.types.length) {
            throw new IllegalArgumentException("Missing parameter");
        }
        Type type = this.types[n];
        Class clazz2 = clazz = type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
        if ((clazz.getModifiers() & 0x400) != 0) {
            throw new IllegalArgumentException("generic parameter must be a concrete class");
        }
        return clazz;
    }

    public T newGenericInstance() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.newGenericInstance(0);
    }

    public T newGenericInstance(int n) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.constructor == null) {
            this.constructor = this.getGenericParameterClass(n).getConstructor(new Class[0]);
        }
        return (T)this.constructor.newInstance(new Object[0]);
    }

    public T newGenericInstance(int n, Object ... objects) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Type type = this.types[n];
        Class rawType = type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
        Class[] types = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            types[i] = objects[i].getClass();
        }
        this.constructor = rawType.getConstructor(types);
        return (T)this.constructor.newInstance(objects);
    }

    public Type getActualTypeParameters(int paramNum, int typeNum) {
        return ((ParameterizedType)this.getGenericType(paramNum)).getActualTypeArguments()[typeNum];
    }

    public boolean equals(Object o) {
        if (o instanceof TypeReference) {
            int len = ((TypeReference)o).types.length;
            if (len != this.types.length) {
                return false;
            }
            for (int i = 0; i < this.types.length; ++i) {
                if (((TypeReference)o).types[i].equals(this.types[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.types.length; ++i) {
            hash = (hash << 1) + this.types[i].hashCode();
        }
        return hash;
    }
}

