/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.daycounters;

import org.jquantlib.daycounters.AbstractDayCounter;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.daycounters.Thirty360;
import org.jquantlib.util.Date;

public class SimpleDayCounter
extends AbstractDayCounter {
    private final DayCounter fallback = Thirty360.getDayCounter();

    @Override
    public final String name() {
        return "Simple";
    }

    @Override
    public final int dayCount(Date dateStart, Date dateEnd) {
        return this.fallback.dayCount(dateStart, dateEnd);
    }

    @Override
    public final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
        int dm1 = dateStart.getDayOfMonth();
        int dm2 = dateEnd.getDayOfMonth();
        int mm1 = dateStart.getMonth();
        int mm2 = dateEnd.getMonth();
        int yy1 = dateStart.getYear();
        int yy2 = dateEnd.getYear();
        if (dm1 == dm2 || dm1 > dm2 && dateEnd.isEndOfMonth() || dm1 < dm2 && dateStart.isEndOfMonth()) {
            return (double)(yy2 - yy1) + (double)(mm2 - mm1) / 12.0;
        }
        return this.fallback.yearFraction(dateStart, dateEnd);
    }

    @Override
    public final double yearFraction(Date dateStart, Date dateEnd) {
        return this.yearFraction(dateStart, dateEnd, Date.NULL_DATE, Date.NULL_DATE);
    }
}

