/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.LocalVolTermStructure;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.util.Date;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public class LocalVolSurface
extends LocalVolTermStructure {
    private Handle<BlackVolTermStructure> blackTS_;
    private Handle<YieldTermStructure> riskFreeTS_;
    private Handle<YieldTermStructure> dividendTS_;
    private Handle<? extends Quote> underlying_;

    public LocalVolSurface(Handle<BlackVolTermStructure> blackTS, Handle<YieldTermStructure> riskFreeTS, Handle<YieldTermStructure> dividendTS, Handle<? extends Quote> underlying) {
        super(blackTS.getLink().dayCounter());
        this.blackTS_ = blackTS;
        this.riskFreeTS_ = riskFreeTS;
        this.dividendTS_ = dividendTS;
        this.underlying_ = underlying;
        this.blackTS_.addObserver(this);
        this.riskFreeTS_.addObserver(this);
        this.dividendTS_.addObserver(this);
        this.underlying_.addObserver(this);
    }

    public LocalVolSurface(Handle<BlackVolTermStructure> blackTS, Handle<YieldTermStructure> riskFreeTS, Handle<YieldTermStructure> dividendTS, double underlying) {
        super(blackTS.getLink().dayCounter());
        this.blackTS_ = blackTS;
        this.riskFreeTS_ = riskFreeTS;
        this.dividendTS_ = dividendTS;
        this.underlying_ = new Handle<SimpleQuote>(new SimpleQuote(underlying));
        this.blackTS_.addObserver(this);
        this.riskFreeTS_.addObserver(this);
        this.dividendTS_.addObserver(this);
    }

    @Override
    public final Date referenceDate() {
        return this.blackTS_.getLink().referenceDate();
    }

    @Override
    public final DayCounter dayCounter() {
        return this.blackTS_.getLink().dayCounter();
    }

    @Override
    public final Date maxDate() {
        return this.blackTS_.getLink().maxDate();
    }

    @Override
    public final double minStrike() {
        return this.blackTS_.getLink().minStrike();
    }

    @Override
    public final double maxStrike() {
        return this.blackTS_.getLink().maxStrike();
    }

    @Override
    protected final double localVolImpl(double time, double underlyingLevel) {
        double dwdt;
        Quote u = this.underlying_.getLink();
        YieldTermStructure dTS = this.dividendTS_.getLink();
        YieldTermStructure rTS = this.riskFreeTS_.getLink();
        BlackVolTermStructure bTS = this.blackTS_.getLink();
        double strike = underlyingLevel;
        double forwardValue = u.evaluate() * (dTS.discount(time, true) / rTS.discount(time, true));
        double y = Math.log(strike / forwardValue);
        double dy = y != 0.0 ? y * 1.0E-6 : 1.0E-6;
        double strikep = strike * Math.exp(dy);
        double strikem = strike / Math.exp(dy);
        double w = bTS.blackVariance(time, strike, true);
        double wp = bTS.blackVariance(time, strikep, true);
        double wm = bTS.blackVariance(time, strikem, true);
        double dwdy = (wp - wm) / (2.0 * dy);
        double d2wdy2 = (wp - 2.0 * w + wm) / (dy * dy);
        double t = time;
        if (t == 0.0) {
            double dt = 1.0E-4;
            double wpt = bTS.blackVariance(t + dt, strike, true);
            if (wpt < w) {
                throw new ArithmeticException("decreasing variance at strike " + strike + " between time " + t + " and time " + t + dt);
            }
            dwdt = (wpt - w) / dt;
        } else {
            double dt = Math.min(1.0E-4, t / 2.0);
            double wpt = bTS.blackVariance(t + dt, strike, true);
            double wmt = bTS.blackVariance(t - dt, strike, true);
            if (wpt < w) {
                throw new ArithmeticException("decreasing variance at strike " + strike + " between time " + t + " and time " + t + dt);
            }
            if (w < wmt) {
                throw new ArithmeticException("decreasing variance at strike " + strike + " between time " + (t - dt) + " and time " + t);
            }
            dwdt = (wpt - wmt) / (2.0 * dt);
        }
        if (dwdy == 0.0 && d2wdy2 == 0.0) {
            return Math.sqrt(dwdt);
        }
        double den1 = 1.0 - y / w * dwdy;
        double den2 = 0.25 * (-0.25 - 1.0 / w + y * y / w / w) * dwdy * dwdy;
        double den3 = 0.5 * d2wdy2;
        double den = den1 + den2 + den3;
        double result = dwdt / den;
        if (result < 0.0) {
            throw new ArithmeticException("negative local vol^2 at strike " + strike + " and time " + t + "; the black vol surface is not smooth enough");
        }
        return Math.sqrt(result);
    }

    @Override
    public void accept(TypedVisitor<TermStructure> v) {
        Visitor<TermStructure> v1;
        Visitor<TermStructure> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 != null) {
            v1.visit(this);
        } else {
            super.accept(v);
        }
    }
}

