/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.RateHelper;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.IMM;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Date;
import org.jquantlib.util.Observable;

public class FuturesRateHelper
extends RateHelper<YieldTermStructure> {
    private double yearFraction;
    private Handle<Quote> convAdj;

    public FuturesRateHelper(Handle<Quote> price, Date immDate, int nMonths, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter, Handle<Quote> convAdj) {
        super(price, null, null, null);
        if (!IMM.getDefaultIMM().isIMMdate(immDate, false)) {
            throw new IllegalArgumentException(" is not a valid IMM date");
        }
        this.earliestDate = immDate;
        this.latestDate = calendar.advance(immDate, new Period(nMonths, TimeUnit.MONTHS), convention, endOfMonth);
        this.yearFraction = dayCounter.yearFraction(this.earliestDate, this.latestDate);
    }

    public FuturesRateHelper(double price, Date immDate, int nMonths, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter, double conv) {
        super(price);
        this.convAdj = new Handle<SimpleQuote>(new SimpleQuote(conv));
        if (!IMM.getDefaultIMM().isIMMdate(immDate, false)) {
            throw new IllegalArgumentException(" is not a valid IMM date");
        }
        this.earliestDate = immDate;
        this.latestDate = calendar.advance(immDate, new Period(nMonths, TimeUnit.MONTHS), convention, endOfMonth);
        this.yearFraction = dayCounter.yearFraction(this.earliestDate, this.latestDate);
    }

    public FuturesRateHelper(double price, Date immDate, IborIndex i, double conv) {
        super(price);
        this.convAdj = new Handle<SimpleQuote>(new SimpleQuote(conv));
        if (!IMM.getDefaultIMM().isIMMdate(immDate, false)) {
            throw new IllegalArgumentException(" is not a valid IMM date");
        }
        this.earliestDate = immDate;
        Calendar cal = i.getFixingCalendar();
        this.latestDate = cal.advance(immDate, i.getTenor(), i.getConvention());
        this.yearFraction = i.getDayCounter().yearFraction(this.earliestDate, this.latestDate);
    }

    @Override
    public double getImpliedQuote() {
        double convA;
        if (this.termStructure == null) {
            throw new IllegalStateException("term structure not set");
        }
        double forwardRate = ((YieldTermStructure)this.termStructure).discount(this.earliestDate) / (((YieldTermStructure)this.termStructure).discount(this.latestDate) - 1.0) / this.yearFraction;
        double d = convA = this.convAdj.isEmpty() ? 0.0 : this.convAdj.getLink().evaluate();
        if (convA < 0.0) {
            throw new IllegalStateException("Negative (" + convA + ") futures convexity adjustment");
        }
        double futureRate = forwardRate + convA;
        return 100.0 * (1.0 - futureRate);
    }

    public double getConvexityAdjustment() {
        return this.convAdj.isEmpty() ? 0.0 : this.convAdj.getLink().evaluate();
    }

    @Override
    public void update(Observable o, Object arg) {
    }
}

