/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.UnicastResponse;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.DelegationRelativeTime;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.io.MarshalledInstance;
import net.jini.io.UnsupportedConstraintException;

public class Plaintext {
    private static final int MAX_USHORT = 65535;
    private static final int SHORT_LEN = 2;
    private static final int SERVICE_ID_LEN = 16;
    private static final Charset utf = Charset.forName("UTF-8");
    private static final Set supportedConstraints = new HashSet();

    private Plaintext() {
    }

    public static short intToUshort(int i) {
        if (i < 0 || i > 65535) {
            throw new IllegalArgumentException("invalid value: " + i);
        }
        return (short)i;
    }

    public static int ushortToInt(short s) {
        return s & 0xFFFF;
    }

    public static byte[] toUtf(String s) throws UTFDataFormatException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(s.length());
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(s);
            return bout.toByteArray();
        }
        catch (UTFDataFormatException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void putUtf(ByteBuffer buf, String s) throws UTFDataFormatException {
        ByteBuffer dup = buf.duplicate();
        dup.putShort((short)0);
        int start = dup.position();
        CoderResult cr = utf.newEncoder().encode(CharBuffer.wrap(s), dup, true);
        if (!cr.isUnderflow()) {
            if (cr.isOverflow()) {
                throw new BufferOverflowException();
            }
            throw new UTFDataFormatException(cr.toString());
        }
        buf.putShort(Plaintext.intToUshort(dup.position() - start));
        buf.position(dup.position());
    }

    public static String getUtf(ByteBuffer buf) throws UTFDataFormatException {
        ByteBuffer dup = buf.duplicate();
        int len = Plaintext.ushortToInt(dup.getShort());
        if (len > dup.remaining()) {
            throw new BufferUnderflowException();
        }
        dup.limit(dup.position() + len);
        try {
            String s = utf.newDecoder().decode(dup).toString();
            buf.position(dup.position());
            return s;
        }
        catch (CharacterCodingException e) {
            throw (UTFDataFormatException)new UTFDataFormatException().initCause(e);
        }
    }

    public static void checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        if (constraints == null) {
            return;
        }
        Iterator i = constraints.requirements().iterator();
        while (i.hasNext()) {
            InvocationConstraint c = (InvocationConstraint)i.next();
            if (Plaintext.supported(c)) continue;
            throw new UnsupportedConstraintException("unsupported constraint: " + c);
        }
    }

    public static void encodeMulticastRequest(MulticastRequest request, DatagramBufferFactory bufs) throws IOException {
        try {
            LinkedList<String> groups = new LinkedList<String>();
            groups.addAll(Arrays.asList(request.getGroups()));
            do {
                ByteBuffer buf = bufs.newBuffer();
                Plaintext.putUtf(buf, request.getHost());
                buf.putShort(Plaintext.intToUshort(request.getPort()));
                int ngroups = 0;
                int ngroupsPos = buf.position();
                buf.putShort((short)0);
                if (!groups.isEmpty()) {
                    Plaintext.putUtf(buf, (String)groups.removeFirst());
                    ++ngroups;
                }
                ServiceID[] ids = request.getServiceIDs();
                int maxIds = Math.min(ids.length, 65535);
                int maxIdsLen = 2 + maxIds * 16;
                if (buf.remaining() > maxIdsLen && !groups.isEmpty()) {
                    int slim = buf.limit();
                    buf.limit(slim - maxIdsLen);
                    try {
                        do {
                            Plaintext.putUtf(buf, (String)groups.getFirst());
                            groups.removeFirst();
                        } while (!groups.isEmpty() && ++ngroups < 65535);
                    }
                    catch (BufferOverflowException e) {
                        // empty catch block
                    }
                    buf.limit(slim);
                }
                buf.putShort(ngroupsPos, Plaintext.intToUshort(ngroups));
                int nids = Math.min(maxIds, (buf.remaining() - 2) / 16);
                buf.putShort(Plaintext.intToUshort(nids));
                for (int i = 0; i < nids; ++i) {
                    ServiceID id = ids[i];
                    buf.putLong(id.getMostSignificantBits());
                    buf.putLong(id.getLeastSignificantBits());
                }
            } while (!groups.isEmpty());
        }
        catch (RuntimeException e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    public static MulticastRequest decodeMulticastRequest(ByteBuffer buf) throws IOException {
        try {
            String host = Plaintext.getUtf(buf);
            int port = Plaintext.ushortToInt(buf.getShort());
            String[] groups = new String[Plaintext.ushortToInt(buf.getShort())];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = Plaintext.getUtf(buf);
            }
            ServiceID[] ids = new ServiceID[Plaintext.ushortToInt(buf.getShort())];
            for (int i = 0; i < ids.length; ++i) {
                long hi = buf.getLong();
                long lo = buf.getLong();
                ids[i] = new ServiceID(hi, lo);
            }
            return new MulticastRequest(host, port, groups, ids);
        }
        catch (RuntimeException e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    public static void encodeMulticastAnnouncement(MulticastAnnouncement announcement, DatagramBufferFactory bufs) throws IOException {
        try {
            LinkedList<String> groups = new LinkedList<String>();
            groups.addAll(Arrays.asList(announcement.getGroups()));
            do {
                int ngroups;
                int ngroupsPos;
                int slim;
                ByteBuffer buf;
                block6: {
                    buf = bufs.newBuffer();
                    slim = buf.limit();
                    buf.limit(slim - 16);
                    buf.putLong(announcement.getSequenceNumber());
                    Plaintext.putUtf(buf, announcement.getHost());
                    buf.putShort(Plaintext.intToUshort(announcement.getPort()));
                    ngroupsPos = buf.position();
                    buf.putShort((short)0);
                    try {
                        for (ngroups = 0; !groups.isEmpty() && ngroups < 65535; ++ngroups) {
                            Plaintext.putUtf(buf, (String)groups.getFirst());
                            groups.removeFirst();
                        }
                    }
                    catch (BufferOverflowException e) {
                        if (ngroups != 0) break block6;
                        throw e;
                    }
                }
                buf.putShort(ngroupsPos, Plaintext.intToUshort(ngroups));
                ServiceID id = announcement.getServiceID();
                buf.limit(slim);
                buf.putLong(id.getMostSignificantBits());
                buf.putLong(id.getLeastSignificantBits());
            } while (!groups.isEmpty());
        }
        catch (RuntimeException e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    public static MulticastAnnouncement decodeMulticastAnnouncement(ByteBuffer buf) throws IOException {
        try {
            long seq = buf.getLong();
            String host = Plaintext.getUtf(buf);
            int port = Plaintext.ushortToInt(buf.getShort());
            String[] groups = new String[Plaintext.ushortToInt(buf.getShort())];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = Plaintext.getUtf(buf);
            }
            long idhi = buf.getLong();
            long idlo = buf.getLong();
            return new MulticastAnnouncement(seq, host, port, groups, new ServiceID(idhi, idlo));
        }
        catch (RuntimeException e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    public static void writeUnicastResponse(OutputStream out, UnicastResponse response, Collection context) throws IOException {
        try {
            DataOutputStream dout = new DataOutputStream(out);
            dout.writeUTF(response.getHost());
            dout.writeShort(Plaintext.intToUshort(response.getPort()));
            String[] groups = response.getGroups();
            dout.writeInt(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                dout.writeUTF(groups[i]);
            }
            new ObjectOutputStream(out).writeObject(new MarshalledInstance(response.getRegistrar(), context));
        }
        catch (RuntimeException e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    public static UnicastResponse readUnicastResponse(InputStream in, ClassLoader defaultLoader, boolean verifyCodebaseIntegrity, ClassLoader verifierLoader, Collection context) throws IOException, ClassNotFoundException {
        try {
            DataInputStream din = new DataInputStream(in);
            String host = din.readUTF();
            int port = din.readUnsignedShort();
            String[] groups = new String[din.readInt()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = din.readUTF();
            }
            MarshalledInstance mi = (MarshalledInstance)new ObjectInputStream(in).readObject();
            ServiceRegistrar reg = (ServiceRegistrar)mi.get(defaultLoader, verifyCodebaseIntegrity, verifierLoader, context);
            return new UnicastResponse(host, port, groups, reg);
        }
        catch (RuntimeException e) {
            throw new DiscoveryProtocolException(null, e);
        }
    }

    private static boolean supported(InvocationConstraint ic) {
        if (ic instanceof ConstraintAlternatives) {
            ConstraintAlternatives ca = (ConstraintAlternatives)ic;
            Iterator i = ca.elements().iterator();
            while (i.hasNext()) {
                if (!Plaintext.supported((InvocationConstraint)i.next())) continue;
                return true;
            }
            return false;
        }
        return supportedConstraints.contains(ic) || supportedConstraints.contains(ic.getClass());
    }

    static {
        supportedConstraints.add(Integrity.NO);
        supportedConstraints.add(Confidentiality.NO);
        supportedConstraints.add(ClientAuthentication.NO);
        supportedConstraints.add(ServerAuthentication.NO);
        supportedConstraints.add(Delegation.NO);
        supportedConstraints.add(ClientMaxPrincipal.class);
        supportedConstraints.add(ClientMaxPrincipalType.class);
        supportedConstraints.add(ClientMinPrincipal.class);
        supportedConstraints.add(ClientMinPrincipalType.class);
        supportedConstraints.add(ServerMinPrincipal.class);
        supportedConstraints.add(DelegationAbsoluteTime.class);
        supportedConstraints.add(DelegationRelativeTime.class);
    }
}

