/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.DelegationRelativeTime;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.io.UnsupportedConstraintException;

class X500Constraints {
    private static final Object SUPPORTED = new Object();
    private static final Object UNSUPPORTED = new Object();
    private static final Set supportedRequestConstraints;
    private static final Set supportedAnnouncementConstraints;
    private static final Set principalConstraints;
    private final InvocationConstraints distilled;

    private X500Constraints(InvocationConstraints distilled) {
        this.distilled = distilled;
    }

    static X500Constraints process(InvocationConstraints constraints, boolean request) throws UnsupportedConstraintException {
        if (constraints == null) {
            constraints = InvocationConstraints.EMPTY;
        }
        return new X500Constraints(new InvocationConstraints(X500Constraints.distill(constraints.requirements(), request, true), X500Constraints.distill(constraints.preferences(), request, false)));
    }

    int checkClientPrincipal(X500Principal principal) {
        Iterator i = this.distilled.requirements().iterator();
        while (i.hasNext()) {
            if (X500Constraints.clientPrincipalSatisfies(principal, (InvocationConstraint)i.next())) continue;
            return -1;
        }
        int satisfied = 0;
        Iterator i2 = this.distilled.preferences().iterator();
        while (i2.hasNext()) {
            if (!X500Constraints.clientPrincipalSatisfies(principal, (InvocationConstraint)i2.next())) continue;
            ++satisfied;
        }
        return satisfied;
    }

    int checkServerPrincipal(X500Principal principal) {
        Iterator i = this.distilled.requirements().iterator();
        while (i.hasNext()) {
            if (X500Constraints.serverPrincipalSatisfies(principal, (InvocationConstraint)i.next())) continue;
            return -1;
        }
        int satisfied = 0;
        Iterator i2 = this.distilled.preferences().iterator();
        while (i2.hasNext()) {
            if (!X500Constraints.serverPrincipalSatisfies(principal, (InvocationConstraint)i2.next())) continue;
            ++satisfied;
        }
        return satisfied;
    }

    private static Collection distill(Set constraints, boolean request, boolean required) throws UnsupportedConstraintException {
        ArrayList<Object> dist = new ArrayList<Object>();
        Iterator i = constraints.iterator();
        while (i.hasNext()) {
            InvocationConstraint c = (InvocationConstraint)i.next();
            Object d = X500Constraints.distill(c, request);
            if (d instanceof InvocationConstraint) {
                dist.add(d);
                continue;
            }
            if (!required || d != UNSUPPORTED) continue;
            throw new UnsupportedConstraintException("unsupported: " + c);
        }
        return dist;
    }

    private static Object distill(InvocationConstraint constraint, boolean request) {
        Set supported;
        Class<?> cl = constraint.getClass();
        Set set = supported = request ? supportedRequestConstraints : supportedAnnouncementConstraints;
        if (supported.contains(constraint) || supported.contains(cl)) {
            return SUPPORTED;
        }
        if (principalConstraints.contains(cl)) {
            return constraint;
        }
        if (constraint instanceof ConstraintAlternatives) {
            ConstraintAlternatives ca = (ConstraintAlternatives)constraint;
            ArrayList<Object> dist = new ArrayList<Object>();
            Iterator i = ca.elements().iterator();
            while (i.hasNext()) {
                Object d = X500Constraints.distill((InvocationConstraint)i.next(), request);
                if (d == SUPPORTED) {
                    return SUPPORTED;
                }
                if (!(d instanceof InvocationConstraint)) continue;
                dist.add(d);
            }
            return dist.isEmpty() ? UNSUPPORTED : ConstraintAlternatives.create(dist);
        }
        return UNSUPPORTED;
    }

    private static boolean clientPrincipalSatisfies(X500Principal principal, InvocationConstraint constraint) {
        if (constraint instanceof ClientMaxPrincipal) {
            return ((ClientMaxPrincipal)constraint).elements().contains(principal);
        }
        if (constraint instanceof ClientMaxPrincipalType) {
            Set s = ((ClientMaxPrincipalType)constraint).elements();
            Iterator i = s.iterator();
            while (i.hasNext()) {
                if (!((Class)i.next()).isInstance(principal)) continue;
                return true;
            }
            return false;
        }
        if (constraint instanceof ClientMinPrincipal) {
            Set s = ((ClientMinPrincipal)constraint).elements();
            return s.size() == 1 && s.contains(principal);
        }
        if (constraint instanceof ClientMinPrincipalType) {
            Set s = ((ClientMinPrincipalType)constraint).elements();
            Iterator i = s.iterator();
            while (i.hasNext()) {
                if (((Class)i.next()).isInstance(principal)) continue;
                return false;
            }
            return true;
        }
        if (constraint instanceof ConstraintAlternatives) {
            Set s = ((ConstraintAlternatives)constraint).elements();
            Iterator i = s.iterator();
            while (i.hasNext()) {
                if (!X500Constraints.clientPrincipalSatisfies(principal, (InvocationConstraint)i.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean serverPrincipalSatisfies(X500Principal principal, InvocationConstraint constraint) {
        if (constraint instanceof ServerMinPrincipal) {
            Set s = ((ServerMinPrincipal)constraint).elements();
            return s.size() == 1 && s.contains(principal);
        }
        if (constraint instanceof ConstraintAlternatives) {
            Set s = ((ConstraintAlternatives)constraint).elements();
            Iterator i = s.iterator();
            while (i.hasNext()) {
                if (!X500Constraints.serverPrincipalSatisfies(principal, (InvocationConstraint)i.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static {
        List<Object> baseSupported = Arrays.asList(Confidentiality.NO, Delegation.NO, DelegationAbsoluteTime.class, DelegationRelativeTime.class, Integrity.YES);
        supportedRequestConstraints = new HashSet<Object>(baseSupported);
        supportedRequestConstraints.add(ClientAuthentication.YES);
        supportedRequestConstraints.add(ServerAuthentication.NO);
        supportedAnnouncementConstraints = new HashSet<Object>(baseSupported);
        supportedAnnouncementConstraints.add(ClientAuthentication.NO);
        supportedAnnouncementConstraints.add(ServerAuthentication.YES);
        principalConstraints = new HashSet();
        principalConstraints.add(ClientMaxPrincipal.class);
        principalConstraints.add(ClientMaxPrincipalType.class);
        principalConstraints.add(ClientMinPrincipal.class);
        principalConstraints.add(ClientMinPrincipalType.class);
        principalConstraints.add(ServerMinPrincipal.class);
    }
}

