/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.async.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import net.sf.cglib.proxy.Enhancer;
import org.apache.aries.async.impl.MethodCall;
import org.apache.aries.async.impl.TrackingInvocationHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.async.Async;
import org.osgi.service.log.LogService;
import org.osgi.util.promise.Promise;
import org.osgi.util.tracker.ServiceTracker;

public class AsyncService
implements Async {
    private final Bundle clientBundle;
    private final ConcurrentMap<Thread, MethodCall> invocations = new ConcurrentHashMap<Thread, MethodCall>();
    private final ExecutorService executor;
    private final ServiceTracker<LogService, LogService> logServiceTracker;

    public AsyncService(Bundle clientBundle, ExecutorService executor, ServiceTracker<LogService, LogService> logServiceTracker) {
        this.clientBundle = clientBundle;
        this.executor = executor;
        this.logServiceTracker = logServiceTracker;
    }

    @Override
    public <T> T mediate(final T service, final Class<T> iface) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return AsyncService.this.privMediate(service, iface);
            }
        });
    }

    private <T> T privMediate(T service, Class<T> iface) {
        TrackingInvocationHandler handler = new TrackingInvocationHandler(this, this.clientBundle, this.logServiceTracker, service);
        if (iface.isInterface()) {
            return (T)Proxy.newProxyInstance(new ClassLoader(service.getClass().getClassLoader()){}, new Class[]{iface}, (InvocationHandler)handler);
        }
        return (T)this.proxyClass(iface, handler, new CGLibAwareClassLoader(service.getClass().getClassLoader()));
    }

    @Override
    public <T> T mediate(final ServiceReference<? extends T> ref, final Class<T> iface) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return AsyncService.this.privMediate(ref, iface);
            }
        });
    }

    private <T> T privMediate(ServiceReference<? extends T> ref, Class<T> iface) {
        TrackingInvocationHandler handler = new TrackingInvocationHandler(this, this.clientBundle, this.logServiceTracker, ref);
        if (iface.isInterface()) {
            return (T)Proxy.newProxyInstance(new ClassLoader(iface.getClassLoader()){}, new Class[]{iface}, (InvocationHandler)handler);
        }
        return (T)this.proxyClass(iface, handler, new CGLibAwareClassLoader(iface.getClassLoader()));
    }

    private Object proxyClass(Class<?> mostSpecificClass, TrackingInvocationHandler handler, ClassLoader classLoader) {
        this.acceptClassType(mostSpecificClass);
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setSuperclass(mostSpecificClass);
        enhancer.setCallback(handler);
        return enhancer.create();
    }

    private void acceptClassType(Class<?> type) {
        if (Modifier.isFinal(type.getModifiers())) {
            throw new IllegalArgumentException("The type " + type.getName() + " is final");
        }
        try {
            type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("The type " + type.getName() + " has no zero-argument constructor", nsme);
        }
        for (Class<?> toCheck = type; toCheck != Object.class; toCheck = toCheck.getSuperclass()) {
            for (Method m : toCheck.getDeclaredMethods()) {
                if (!Modifier.isFinal(m.getModifiers())) continue;
                throw new IllegalArgumentException("The type hierarchy for " + type.getName() + " has a final method " + m.getName() + " defined on " + toCheck.getName());
            }
        }
    }

    public <T> Promise<T> call(T call) throws IllegalStateException {
        MethodCall currentInvocation = this.consumeCurrentInvocation();
        if (currentInvocation == null) {
            throw new IllegalStateException("Incorrect API usage - this thread has no pending method calls");
        }
        return currentInvocation.invokeAsynchronously(this.clientBundle, this.executor);
    }

    @Override
    public Promise<?> call() throws IllegalStateException {
        return this.call((T)null);
    }

    @Override
    public Promise<Void> execute() throws IllegalStateException {
        MethodCall currentInvocation = this.consumeCurrentInvocation();
        if (currentInvocation == null) {
            throw new IllegalStateException("Incorrect API usage - this thread has no pending method calls");
        }
        return currentInvocation.fireAndForget(this.clientBundle, this.executor);
    }

    void registerInvocation(MethodCall invocation) {
        if (this.invocations.putIfAbsent(Thread.currentThread(), invocation) != null) {
            this.invocations.remove(Thread.currentThread());
            throw new IllegalStateException("Incorrect API usage - this thread already has a pending method call");
        }
    }

    MethodCall consumeCurrentInvocation() {
        return (MethodCall)this.invocations.remove(Thread.currentThread());
    }

    private static final class CGLibAwareClassLoader
    extends ClassLoader {
        private final ClassLoader serviceTypeLoader;

        private CGLibAwareClassLoader(Bundle registeringBundle) {
            this.serviceTypeLoader = ((BundleWiring)registeringBundle.adapt(BundleWiring.class)).getClassLoader();
        }

        private CGLibAwareClassLoader(ClassLoader loader) {
            this.serviceTypeLoader = loader;
        }

        @Override
        protected Class<?> findClass(String var0) throws ClassNotFoundException {
            if (var0.startsWith("net.sf.cglib")) {
                return AsyncService.class.getClassLoader().loadClass(var0);
            }
            return this.serviceTypeLoader.loadClass(var0);
        }
    }
}

