/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.instruments.Instrument;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.pricingengines.arguments.Arguments;
import org.jquantlib.pricingengines.results.Results;

public abstract class NewInstrument
extends Instrument {
    private static final String SHOULD_DEFINE_PRICING_ENGINE = "Should define pricing engine";
    protected PricingEngine engine;

    protected abstract void setupArguments(Arguments var1);

    protected NewInstrument() {
        this.engine = null;
    }

    protected NewInstrument(PricingEngine engine) {
        this.setPricingEngine(engine);
    }

    public final void setPricingEngine(PricingEngine engine) {
        if (this.engine != null) {
            this.engine.deleteObserver(this);
        }
        this.engine = engine;
        if (this.engine != null) {
            this.engine.addObserver(this);
        }
        this.update(this, null);
    }

    @Override
    protected final void performCalculations() {
        if (this.engine == null) {
            throw new NullPointerException(SHOULD_DEFINE_PRICING_ENGINE);
        }
        this.engine.reset();
        this.setupArguments(this.engine.getArguments());
        this.engine.getArguments().validate();
        this.engine.calculate();
        this.fetchResults(this.engine.getResults());
    }

    @Override
    protected void setupExpired() {
        super.setupExpired();
    }

    protected void fetchResults(Results results) {
        this.NPV = results.value;
        this.errorEstimate = results.errorEstimate;
    }
}

