/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import org.jquantlib.math.Array;
import org.jquantlib.math.TransformedGrid;
import org.jquantlib.methods.finitedifferences.Pde;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;

public abstract class PdeSecondOrderParabolic
implements Pde {
    public void generateOperator(double t, TransformedGrid tg, TridiagonalOperator L) {
        for (int i = 1; i < tg.size() - 1; ++i) {
            double sigma = this.diffusion(t, tg.grid(i));
            double nu = this.drift(t, tg.grid(i));
            double r = this.discount(t, tg.grid(i));
            double sigma2 = sigma * sigma;
            double pd = -(sigma2 / tg.dxm(i) - nu) / tg.dx(i);
            double pu = -(sigma2 / tg.dxp(i) + nu) / tg.dx(i);
            double pm = sigma2 / (tg.dxm(i) * tg.dxp(i)) + r;
            L.setMidRow(i, pd, pm, pu);
        }
    }

    public TransformedGrid applyGridType(Array a) {
        return null;
    }
}

