/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.AmericanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.distributions.NormalDistribution;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.pricingengines.BlackFormula;
import org.jquantlib.pricingengines.VanillaOptionEngine;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.pricingengines.vanilla.BaroneAdesiWhaleyApproximationEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class JuQuadraticApproximationEngine
extends VanillaOptionEngine {
    @Override
    public void calculate() {
        if (((OneAssetOptionArguments)this.arguments).exercise.type() != Exercise.Type.AMERICAN) {
            throw new ArithmeticException("not an American Option");
        }
        if (!(((OneAssetOptionArguments)this.arguments).exercise instanceof AmericanExercise)) {
            throw new ArithmeticException("non-American exercise given");
        }
        AmericanExercise ex = (AmericanExercise)((OneAssetOptionArguments)this.arguments).exercise;
        if (ex.payoffAtExpiry()) {
            throw new ArithmeticException("payoff at expiry not handled");
        }
        if (!(((OneAssetOptionArguments)this.arguments).payoff instanceof StrikedTypePayoff)) {
            throw new ArithmeticException("non-striked payoff given");
        }
        StrikedTypePayoff payoff = (StrikedTypePayoff)((OneAssetOptionArguments)this.arguments).payoff;
        if (!(((OneAssetOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new ArithmeticException("Black-Scholes process required");
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((OneAssetOptionArguments)this.arguments).stochasticProcess;
        double variance = process.blackVolatility().getLink().blackVariance(ex.lastDate(), payoff.strike());
        double dividendDiscount = process.dividendYield().getLink().discount(ex.lastDate());
        double riskFreeDiscount = process.riskFreeRate().getLink().discount(ex.lastDate());
        double spot = process.stateVariable().getLink().evaluate();
        double forwardPrice = spot * dividendDiscount / riskFreeDiscount;
        BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
        if (dividendDiscount >= 1.0 && payoff.optionType() == Option.Type.CALL) {
            ((OneAssetOptionResults)this.results).value = black.value();
            ((OneAssetOptionResults)this.results).delta = black.delta(spot);
            ((OneAssetOptionResults)this.results).deltaForward = black.deltaForward();
            ((OneAssetOptionResults)this.results).elasticity = black.elasticity(spot);
            ((OneAssetOptionResults)this.results).gamma = black.gamma(spot);
            DayCounter rfdc = process.riskFreeRate().getLink().dayCounter();
            DayCounter divdc = process.dividendYield().getLink().dayCounter();
            DayCounter voldc = process.blackVolatility().getLink().dayCounter();
            double t = rfdc.yearFraction(process.riskFreeRate().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
            ((OneAssetOptionResults)this.results).rho = black.rho(t);
            t = divdc.yearFraction(process.dividendYield().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
            ((OneAssetOptionResults)this.results).dividendRho = black.dividendRho(t);
            t = voldc.yearFraction(process.blackVolatility().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
            ((OneAssetOptionResults)this.results).vega = black.vega(t);
            ((OneAssetOptionResults)this.results).theta = black.theta(spot, t);
            ((OneAssetOptionResults)this.results).thetaPerDay = black.thetaPerDay(spot, t);
            ((OneAssetOptionResults)this.results).strikeSensitivity = black.strikeSensitivity();
            ((OneAssetOptionResults)this.results).itmCashProbability = black.itmCashProbability();
        } else {
            double phi;
            CumulativeNormalDistribution cumNormalDist = new CumulativeNormalDistribution();
            NormalDistribution normalDist = new NormalDistribution();
            double tolerance = 1.0E-6;
            double Sk = BaroneAdesiWhaleyApproximationEngine.criticalPrice(payoff, riskFreeDiscount, dividendDiscount, variance, tolerance);
            double forwardSk = Sk * dividendDiscount / riskFreeDiscount;
            double alpha = -2.0 * Math.log(riskFreeDiscount) / variance;
            double beta = 2.0 * Math.log(dividendDiscount / riskFreeDiscount) / variance;
            double h = 1.0 - riskFreeDiscount;
            switch (payoff.optionType()) {
                case CALL: {
                    phi = 1.0;
                    break;
                }
                case PUT: {
                    phi = -1.0;
                    break;
                }
                default: {
                    throw new ArithmeticException("unknown option type");
                }
            }
            double temp_root = Math.sqrt((beta - 1.0) * (beta - 1.0) + 4.0 * alpha / h);
            double lambda = (-(beta - 1.0) + phi * temp_root) / 2.0;
            double lambda_prime = -phi * alpha / (h * h * temp_root);
            double black_Sk = BlackFormula.blackFormula(payoff.optionType(), payoff.strike(), forwardSk, Math.sqrt(variance)) * riskFreeDiscount;
            double hA = phi * (Sk - payoff.strike()) - black_Sk;
            double d1_Sk = (Math.log(forwardSk / payoff.strike()) + 0.5 * variance) / Math.sqrt(variance);
            double d2_Sk = d1_Sk - Math.sqrt(variance);
            double part1 = forwardSk * normalDist.evaluate(d1_Sk) / (alpha * Math.sqrt(variance));
            double part2 = -phi * forwardSk * cumNormalDist.evaluate(phi * d1_Sk) * Math.log(dividendDiscount) / Math.log(riskFreeDiscount);
            double part3 = phi * payoff.strike() * cumNormalDist.evaluate(phi * d2_Sk);
            double V_E_h = part1 + part2 + part3;
            double b = (1.0 - h) * alpha * lambda_prime / (2.0 * (2.0 * lambda + beta - 1.0));
            double c = -((1.0 - h) * alpha / (2.0 * lambda + beta - 1.0)) * (V_E_h / hA + 1.0 / h + lambda_prime / (2.0 * lambda + beta - 1.0));
            double temp_spot_ratio = Math.log(spot / Sk);
            double chi = temp_spot_ratio * (b * temp_spot_ratio + c);
            ((OneAssetOptionResults)this.results).value = phi * (Sk - spot) > 0.0 ? black.value() + hA * Math.pow(spot / Sk, lambda) / (1.0 - chi) : phi * (spot - payoff.strike());
            if (Double.isNaN(((OneAssetOptionResults)this.results).value)) {
                double hh;
                double gg = hh = 0.0;
            }
            double temp_chi_prime = 2.0 * b / spot * Math.log(spot / Sk);
            double chi_prime = temp_chi_prime + c / spot;
            double chi_double_prime = 2.0 * b / (spot * spot) - temp_chi_prime / spot - c / (spot * spot);
            ((OneAssetOptionResults)this.results).delta = phi * dividendDiscount * cumNormalDist.evaluate(phi * d1_Sk) + (lambda / (spot * (1.0 - chi)) + chi_prime / ((1.0 - chi) * (1.0 - chi))) * (phi * (Sk - payoff.strike()) - black_Sk) * Math.pow(spot / Sk, lambda);
            ((OneAssetOptionResults)this.results).gamma = phi * dividendDiscount * normalDist.evaluate(phi * d1_Sk) / (spot * Math.sqrt(variance)) + (2.0 * lambda * chi_prime / (spot * (1.0 - chi) * (1.0 - chi)) + 2.0 * chi_prime * chi_prime / ((1.0 - chi) * (1.0 - chi) * (1.0 - chi)) + chi_double_prime / ((1.0 - chi) * (1.0 - chi)) + lambda * (1.0 - lambda) / (spot * spot * (1.0 - chi))) * (phi * (Sk - payoff.strike()) - black_Sk) * Math.pow(spot / Sk, lambda);
        }
    }
}

