/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.AbstractCalendar;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Weekday;
import org.jquantlib.util.Date;

public class JointCalendar
extends AbstractCalendar {
    private JointCalendarRule joinRule;
    private Calendar[] calendars;

    public JointCalendar(JointCalendarRule rule, Calendar ... calendar) {
        this.calendars = calendar;
        this.joinRule = rule;
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder();
        switch (this.joinRule) {
            case JOIN_HOLIDAYS: {
                builder.append("JoinHolidays(");
                break;
            }
            case JOIN_BUSINESSDAYS: {
                builder.append("JoinBusinessDays()");
                break;
            }
            default: {
                throw new IllegalStateException("unknown joint calendar rule");
            }
        }
        for (Calendar cal : this.calendars) {
            builder.append(cal.getName() + ",");
        }
        builder.insert(builder.length() - 1, ")");
        return builder.toString();
    }

    @Override
    public boolean isBusinessDay(Date d) {
        switch (this.joinRule) {
            case JOIN_HOLIDAYS: {
                for (Calendar cal : this.calendars) {
                    if (!cal.isHoliday(d)) continue;
                    return false;
                }
                return true;
            }
            case JOIN_BUSINESSDAYS: {
                for (Calendar cal : this.calendars) {
                    if (cal.isHoliday(d)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalStateException("unknown joint calendar rule");
    }

    @Override
    public boolean isWeekend(Weekday w) {
        switch (this.joinRule) {
            case JOIN_HOLIDAYS: {
                for (Calendar cal : this.calendars) {
                    if (!cal.isWeekend(w)) continue;
                    return true;
                }
                return false;
            }
            case JOIN_BUSINESSDAYS: {
                for (Calendar cal : this.calendars) {
                    if (cal.isWeekend(w)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException("unknown joint calendar rule");
    }

    public static enum JointCalendarRule {
        JOIN_HOLIDAYS,
        JOIN_BUSINESSDAYS;

    }
}

