/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.repo.provider;

import aQute.bnd.http.HttpRequestException;
import aQute.bnd.service.url.TaggedData;
import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.maven.repo.api.Archive;
import aQute.maven.repo.api.IMavenRepo;
import aQute.maven.repo.api.Program;
import aQute.maven.repo.api.Release;
import aQute.maven.repo.api.Revision;
import aQute.maven.repo.provider.Releaser;
import aQute.maven.repo.provider.RemoteRepo;
import aQute.maven.repo.provider.SnapshotReleaser;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;

public class MavenStorage
implements IMavenRepo,
Closeable {
    final File base;
    final String id;
    final RemoteRepo release;
    final RemoteRepo snapshot;
    final Executor executor;
    final boolean localOnly;
    long STALE_TIME = TimeUnit.DAYS.toMillis(1L);

    public MavenStorage(File base, String id, RemoteRepo release, RemoteRepo snapshot, Executor executor, Reporter reporter, Callable<Boolean> callback) throws Exception {
        this.base = base;
        this.id = id;
        this.release = release;
        this.snapshot = snapshot == null ? release : snapshot;
        this.executor = executor == null ? Executors.newCachedThreadPool() : executor;
        this.localOnly = release == null && snapshot == null;
    }

    @Override
    public List<Revision> getRevisions(Program program) throws Exception {
        ArrayList<Revision> revisions = new ArrayList<Revision>();
        if (this.release != null) {
            this.release.getRevisions(program, revisions);
        }
        if (this.snapshot != null && this.snapshot != this.release) {
            this.snapshot.getRevisions(program, revisions);
        }
        return revisions;
    }

    @Override
    public List<Archive> getSnapshotArchives(Revision revision) throws Exception {
        if (!revision.isSnapshot() || this.snapshot == null) {
            return null;
        }
        return this.snapshot.getSnapshotArchives(revision);
    }

    @Override
    public Archive getResolvedArchive(Revision revision, String extension, String classifier) throws Exception {
        if (revision.isSnapshot()) {
            MavenVersion v = this.snapshot.getVersion(revision);
            return revision.archive(v, extension, classifier);
        }
        return revision.archive(extension, classifier);
    }

    @Override
    public Release release(Revision revision) throws Exception {
        File target = this.toLocalFile(revision.path);
        File temp = IO.createTempFile((File)this.base, (String)revision.toString(), (String)".tmp");
        temp.mkdirs();
        Releaser r = revision.isSnapshot() ? new SnapshotReleaser(this, revision) : new Releaser(this, revision);
        r.force();
        return r;
    }

    @Override
    public Promise<File> get(final Archive archive) throws Exception {
        final Deferred deferred = new Deferred();
        final File file = this.toLocalFile(archive);
        if (this.localOnly) {
            if (file.isFile()) {
                deferred.resolve((Object)file);
            } else {
                deferred.resolve(null);
            }
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        File f = MavenStorage.this.get0(archive, file);
                        deferred.resolve((Object)f);
                    }
                    catch (Throwable e) {
                        deferred.fail(e);
                    }
                }
            });
        }
        return deferred.getPromise();
    }

    private File get0(Archive archive, File file) throws Exception {
        TaggedData result = null;
        if (archive.revision.isSnapshot()) {
            Archive resolved = this.resolveSnapshot(archive);
            if (this.snapshot != null) {
                result = this.snapshot.fetch(resolved.remotePath, file);
            }
        } else if (this.release != null) {
            result = this.release.fetch(archive.remotePath, file);
        }
        if (result == null) {
            throw new IllegalStateException("Neither release nor remote repo set");
        }
        switch (result.getState()) {
            case NOT_FOUND: {
                return null;
            }
            case OTHER: {
                throw new HttpRequestException((HttpURLConnection)result.getConnection());
            }
        }
        return file;
    }

    @Override
    public Archive resolveSnapshot(Archive archive) throws Exception {
        if (archive.isResolved()) {
            return archive;
        }
        if (this.snapshot == null) {
            return null;
        }
        MavenVersion version = this.snapshot.getVersion(archive.revision);
        return archive.resolveSnapshot(version);
    }

    public File toLocalFile(String path) {
        return IO.getFile((File)this.base, (String)path);
    }

    @Override
    public File toLocalFile(Archive archive) {
        return this.toLocalFile(archive.localPath);
    }

    @Override
    public long getLastUpdated(Revision revision) throws Exception {
        if (revision.isSnapshot()) {
            File metafile = this.toLocalFile(revision.metadata(this.id));
            return metafile.lastModified();
        }
        File dir = this.toLocalFile(revision.path);
        return dir.lastModified();
    }

    @Override
    public Archive getArchive(String s) throws Exception {
        Matcher matcher = ARCHIVE_P.matcher(Strings.trim((String)s));
        if (!matcher.matches()) {
            return null;
        }
        String group = Strings.trim((String)matcher.group("group"));
        String artifact = Strings.trim((String)matcher.group("artifact"));
        String extension = Strings.trim((String)matcher.group("extension"));
        String classifier = Strings.trim((String)matcher.group("classifier"));
        String version = Strings.trim((String)matcher.group("version"));
        return Program.valueOf(group, artifact).version(version).archive(extension, classifier);
    }

    @Override
    public void close() throws IOException {
        if (this.release != null) {
            this.release.close();
        }
    }

    @Override
    public URI toRemoteURI(Archive archive) throws Exception {
        return archive.revision.isSnapshot() ? this.snapshot.toURI(archive.remotePath) : this.release.toURI(archive.remotePath);
    }

    public void store(Archive archive, InputStream in) throws IOException {
        File file = IO.getFile((File)this.base, (String)archive.localPath);
        IO.copy((InputStream)in, (File)file);
    }

    @Override
    public void refresh() throws IOException {
    }
}

