/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.repo.provider;

import aQute.bnd.http.HttpClient;
import aQute.bnd.http.HttpRequestException;
import aQute.bnd.service.url.State;
import aQute.bnd.service.url.TaggedData;
import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.cryptography.Digest;
import aQute.libg.cryptography.MD5;
import aQute.libg.cryptography.SHA1;
import aQute.maven.repo.api.Archive;
import aQute.maven.repo.api.Program;
import aQute.maven.repo.api.Revision;
import aQute.maven.repo.provider.MetadataParser;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.util.promise.Promise;

public class RemoteRepo
implements Closeable {
    final HttpClient client;
    final String base;
    final Map<Revision, MetadataParser.RevisionMetadata> revisions = new ConcurrentHashMap<Revision, MetadataParser.RevisionMetadata>();
    final Map<Program, MetadataParser.ProgramMetadata> programs = new ConcurrentHashMap<Program, MetadataParser.ProgramMetadata>();
    final String id;
    final File root;

    public RemoteRepo(File root, HttpClient client, String base) throws Exception {
        this.root = root;
        this.client = client;
        this.base = base;
        this.id = RemoteRepo.toName(base);
    }

    public static String toName(String uri) throws Exception {
        return SHA1.digest((byte[])uri.getBytes(StandardCharsets.UTF_8)).asHex();
    }

    public TaggedData fetch(String path, File file) throws Exception {
        URL url = new URL(String.valueOf(this.base) + path);
        int n = 0;
        while (true) {
            try {
                URL shaUrl = new URL(String.valueOf(this.base) + path + ".sha1");
                URL md5Url = new URL(String.valueOf(this.base) + path + ".md5");
                Promise sha = this.client.build().asString().timeout(5000L).async(shaUrl);
                Promise md5 = this.client.build().asString().timeout(5000L).async(md5Url);
                TaggedData tag = (TaggedData)this.client.build().useCache(file).asTag().go(url);
                if (tag.getState() == State.UPDATED) {
                    if (sha.getFailure() == null) {
                        String fileSha = SHA1.digest((File)file).asHex();
                        this.checkDigest(fileSha, (String)sha.getValue(), file);
                    } else if (md5.getFailure() == null) {
                        String fileMD5 = MD5.digest((File)file).asHex();
                        this.checkDigest(fileMD5, (String)md5.getValue(), file);
                    }
                }
                return tag;
            }
            catch (Exception e) {
                if (++n > 3) {
                    throw e;
                }
                Thread.sleep(1000 * n);
                continue;
            }
            break;
        }
    }

    private void checkDigest(String fileSha, String remoteSha, File file) {
        if (remoteSha == null) {
            return;
        }
        try {
            int start = 0;
            while (start < remoteSha.length() && Character.isWhitespace(remoteSha.charAt(start))) {
                ++start;
            }
            int i = 0;
            while (i < fileSha.length()) {
                char them;
                char us;
                if (start + i >= remoteSha.length() || (us = fileSha.charAt(i)) != (them = remoteSha.charAt(start + i)) && Character.toLowerCase(us) != Character.toLowerCase(them)) {
                    throw new IllegalArgumentException("Invalid checksum content " + remoteSha + " for " + file);
                }
                ++i;
            }
        }
        catch (Exception e) {
            file.delete();
            throw e;
        }
    }

    private String getDigest(String value) {
        return null;
    }

    void doChecksum(String type, Digest local, Promise<String> remote, File file) throws InvocationTargetException, InterruptedException, IOException {
        String r;
        if (remote.getFailure() != null || remote.getValue() == null) {
            return;
        }
        String l = local.asHex();
        if (!l.equalsIgnoreCase(r = Strings.trim((String)((String)remote.getValue())))) {
            throw new IllegalStateException("Invalid " + type + " remote=" + (String)remote.getValue() + " local=" + local.asHex() + " for " + file);
        }
        File checksumFile = new File(String.valueOf(file.getAbsolutePath()) + "." + type);
        IO.store((Object)remote.getValue(), (File)checksumFile);
    }

    public void store(File file, String path) throws Exception {
        boolean n = false;
        URL url = new URL(String.valueOf(this.base) + path);
        SHA1 sha1 = SHA1.digest((File)file);
        MD5 md5 = MD5.digest((File)file);
        Promise psha = this.client.build().put().upload((Object)sha1.asHex()).asString().async(new URL(String.valueOf(this.base) + path + ".sha1"));
        Promise pmd5 = this.client.build().put().upload((Object)md5.asHex()).asString().async(new URL(String.valueOf(this.base) + path + ".md5"));
        TaggedData go = (TaggedData)this.client.build().put().upload((Object)file).asTag().go(url);
        if (go.getResponseCode() != 201 && go.getResponseCode() != 200) {
            throw new IOException("Could not store " + path + " from " + file + " with " + go);
        }
        if (psha.getFailure() != null) {
            throw (Exception)psha.getFailure();
        }
        if (pmd5.getFailure() != null) {
            throw (Exception)psha.getFailure();
        }
    }

    public boolean delete(String path) throws Exception {
        URL url = new URL(String.valueOf(this.base) + path);
        TaggedData go = (TaggedData)this.client.build().put().delete().get(TaggedData.class).go(url);
        if (go == null) {
            return false;
        }
        if (go.getResponseCode() == 200 || go.getResponseCode() == 204) {
            this.client.build().delete().async(new URL(String.valueOf(this.base) + path + ".sha1"));
            this.client.build().delete().async(new URL(String.valueOf(this.base) + path + ".md5"));
            return true;
        }
        throw new HttpRequestException(go);
    }

    @Override
    public void close() {
    }

    public URI toURI(String remotePath) throws Exception {
        return new URI(String.valueOf(this.base) + remotePath);
    }

    public void getRevisions(Program program, List<Revision> revisions) throws Exception {
        MetadataParser.ProgramMetadata meta = this.getMetadata(program);
        for (MavenVersion v : meta.versions) {
            revisions.add(program.version(v));
        }
    }

    MetadataParser.RevisionMetadata getMetadata(Revision revision) throws Exception {
        File metafile = IO.getFile((File)this.root, (String)revision.metadata(this.id));
        MetadataParser.RevisionMetadata metadata = this.revisions.get(revision);
        TaggedData tag = (TaggedData)this.client.build().useCache(metafile).asTag().go(new URI(String.valueOf(this.base) + revision.metadata()));
        if (tag.getState() == State.NOT_FOUND || tag.getState() == State.OTHER) {
            if (metadata == null) {
                metadata = new MetadataParser.RevisionMetadata();
                this.revisions.put(revision, metadata);
                return metadata;
            }
            throw new IOException("HTTP failed:" + tag.getResponseCode());
        }
        if (metadata == null || tag.getState() == State.UPDATED) {
            metadata = MetadataParser.parseRevisionMetadata(metafile);
            this.revisions.put(revision, metadata);
        }
        return metadata;
    }

    MetadataParser.ProgramMetadata getMetadata(Program program) throws Exception {
        File metafile = IO.getFile((File)this.root, (String)program.metadata(this.id));
        MetadataParser.ProgramMetadata metadata = this.programs.get(program);
        TaggedData tag = (TaggedData)this.client.build().useCache(metafile).asTag().go(new URI(String.valueOf(this.base) + program.metadata()));
        if (tag == null || tag.isOk() || metadata == null) {
            metadata = MetadataParser.parseProgramMetadata(metafile);
            this.programs.put(program, metadata);
        } else if (!tag.isNotModified()) {
            throw new IOException("HTTP failed:" + tag.getResponseCode());
        }
        return metadata;
    }

    public List<Archive> getSnapshotArchives(Revision revision) throws Exception {
        MetadataParser.RevisionMetadata metadata = this.getMetadata(revision);
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (MetadataParser.SnapshotVersion snapshotVersion : metadata.snapshotVersions) {
            Archive archive = revision.archive(snapshotVersion.value, snapshotVersion.extension, snapshotVersion.classifier);
            archives.add(archive);
        }
        return archives;
    }

    public MavenVersion getVersion(Revision revision) throws Exception {
        MetadataParser.RevisionMetadata metadata = this.getMetadata(revision);
        return revision.version.toSnapshot(metadata.snapshot.timestamp, metadata.snapshot.buildNumber);
    }

    public String getId() {
        return this.id;
    }
}

