/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.util.tracker.AbstractTracked;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    final ServiceTrackerCustomizer customizer;
    final String listenerFilter;
    private final String trackClass;
    private final ServiceReference trackReference;
    private volatile Tracked tracked;
    private volatile ServiceReference cachedReference;
    private volatile Object cachedService;
    private static final Version endMatchVersion = new Version(1, 5, 0);

    public ServiceTracker(BundleContext context, ServiceReference reference, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = reference;
        this.trackClass = null;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(service.id=" + reference.getProperty("service.id").toString() + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    public ServiceTracker(BundleContext context, String clazz, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = clazz;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(objectClass=" + clazz + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    public ServiceTracker(final BundleContext context, Filter filter, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = null;
        Version frameworkVersion = (Version)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String version = context.getProperty("org.osgi.framework.version");
                return version == null ? Version.emptyVersion : new Version(version);
            }
        });
        boolean endMatchSupported = frameworkVersion.compareTo(endMatchVersion) >= 0;
        this.listenerFilter = endMatchSupported ? filter.toString() : null;
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer = this.customizer = customizer == null ? this : customizer;
        if (context == null || filter == null) {
            throw new NullPointerException();
        }
    }

    public void open() {
        this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(boolean trackAllServices) {
        if (this.tracked != null) {
            return;
        }
        Tracked tracked = this.tracked = trackAllServices ? new AllTracked() : new Tracked();
        synchronized (tracked) {
            try {
                this.context.addServiceListener(this.tracked, this.listenerFilter);
                Object[] references = this.trackClass != null ? this.getInitialReferences(trackAllServices, this.trackClass, null) : (this.trackReference != null ? new ServiceReference[]{this.trackReference} : this.getInitialReferences(trackAllServices, null, this.listenerFilter != null ? this.listenerFilter : this.filter.toString()));
                this.tracked.setInitial(references);
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage());
            }
        }
        this.tracked.trackInitial();
    }

    private ServiceReference[] getInitialReferences(boolean trackAllServices, String trackClass, String filterString) throws InvalidSyntaxException {
        if (trackAllServices) {
            return this.context.getAllServiceReferences(trackClass, filterString);
        }
        return this.context.getServiceReferences(trackClass, filterString);
    }

    public synchronized void close() {
        if (this.tracked == null) {
            return;
        }
        this.tracked.close();
        ServiceReference[] references = this.getServiceReferences();
        Tracked outgoing = this.tracked;
        this.tracked = null;
        try {
            this.context.removeServiceListener(outgoing);
        }
        catch (IllegalStateException illegalStateException) {}
        if (references != null) {
            int i = 0;
            while (i < references.length) {
                outgoing.untrack(references[i], null);
                ++i;
            }
        }
    }

    public Object addingService(ServiceReference reference) {
        return this.context.getService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked tracked = this.tracked;
            if (tracked == null) {
                return null;
            }
            Tracked tracked2 = tracked;
            synchronized (tracked2) {
                if (tracked.size() == 0) {
                    tracked.wait(timeout);
                }
            }
            object = this.getService();
            if (timeout <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int length;
            block5: {
                length = tracked.size();
                if (length != 0) break block5;
                return null;
            }
            Object[] references = new ServiceReference[length];
            tracked.getTracked(references);
            return references;
        }
    }

    public ServiceReference getServiceReference() {
        int length;
        ServiceReference reference = this.cachedReference;
        if (reference != null) {
            return reference;
        }
        ServiceReference[] references = this.getServiceReferences();
        int n = length = references == null ? 0 : references.length;
        if (length == 0) {
            return null;
        }
        int index = 0;
        if (length > 1) {
            int[] rankings = new int[length];
            int count = 0;
            int maxRanking = Integer.MIN_VALUE;
            int i = 0;
            while (i < length) {
                int ranking;
                Object property = references[i].getProperty("service.ranking");
                rankings[i] = ranking = property instanceof Integer ? (Integer)property : 0;
                if (ranking > maxRanking) {
                    index = i;
                    maxRanking = ranking;
                    count = 1;
                } else if (ranking == maxRanking) {
                    ++count;
                }
                ++i;
            }
            if (count > 1) {
                long minId = Long.MAX_VALUE;
                int i2 = 0;
                while (i2 < length) {
                    long id;
                    if (rankings[i2] == maxRanking && (id = ((Long)references[i2].getProperty("service.id")).longValue()) < minId) {
                        index = i2;
                        minId = id;
                    }
                    ++i2;
                }
            }
        }
        this.cachedReference = references[index];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference reference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getCustomizedObject(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int length;
            ServiceReference[] references;
            block6: {
                references = this.getServiceReferences();
                int n = length = references == null ? 0 : references.length;
                if (length != 0) break block6;
                return null;
            }
            Object[] objects = new Object[length];
            int i = 0;
            while (i < length) {
                objects[i] = this.getService(references[i]);
                ++i;
            }
            return objects;
        }
    }

    public Object getService() {
        Object service = this.cachedService;
        if (service != null) {
            return service;
        }
        ServiceReference reference = this.getServiceReference();
        if (reference == null) {
            return null;
        }
        this.cachedService = this.getService(reference);
        return this.cachedService;
    }

    public void remove(ServiceReference reference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return;
        }
        tracked.untrack(reference, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return 0;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return -1;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getTrackingCount();
        }
    }

    void modified() {
        this.cachedReference = null;
        this.cachedService = null;
    }

    class AllTracked
    extends Tracked
    implements AllServiceListener {
        protected AllTracked() {
        }
    }

    class Tracked
    extends AbstractTracked
    implements ServiceListener {
        protected Tracked() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            switch (event.getType()) {
                case 1: 
                case 2: {
                    if (ServiceTracker.this.listenerFilter != null) {
                        this.track(reference, event);
                        break;
                    }
                    if (ServiceTracker.this.filter.match(reference)) {
                        this.track(reference, event);
                        break;
                    }
                    this.untrack(reference, event);
                    break;
                }
                case 4: 
                case 8: {
                    this.untrack(reference, event);
                }
            }
        }

        protected void modified() {
            super.modified();
            ServiceTracker.this.modified();
        }

        protected Object customizerAdding(Object item, Object related) {
            return ServiceTracker.this.customizer.addingService((ServiceReference)item);
        }

        protected void customizerModified(Object item, Object related, Object object) {
            ServiceTracker.this.customizer.modifiedService((ServiceReference)item, object);
        }

        protected void customizerRemoved(Object item, Object related, Object object) {
            ServiceTracker.this.customizer.removedService((ServiceReference)item, object);
        }
    }
}

