/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import java.util.Currency;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.InterestRateIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Period;
import org.jquantlib.util.Date;

public class IborIndex
extends InterestRateIndex {
    private BusinessDayConvention convention;
    private Handle<YieldTermStructure> termStructure;
    private boolean endOfMonth;

    public IborIndex(String familyName, Period tenor, int fixingDays, Calendar fixingCalendar, Currency currency, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter, Handle<YieldTermStructure> handle) {
        super(familyName, tenor, fixingDays, fixingCalendar, currency, dayCounter);
        this.convention = convention;
        this.termStructure = handle;
        this.endOfMonth = endOfMonth;
        if (handle != null) {
            handle.getLink().addObserver(this);
        }
    }

    public IborIndex(String familyName, Period tenor, int fixingDays, Calendar fixingCalendar, Currency currency, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        super(familyName, tenor, fixingDays, fixingCalendar, currency, dayCounter);
        this.convention = convention;
        this.endOfMonth = endOfMonth;
    }

    @Override
    protected double forecastFixing(Date fixingDate) {
        if (!this.termStructure.isEmpty()) {
            throw new IllegalStateException("no forecasting term structure set to " + this.getName());
        }
        Date fixingValueDate = this.valueDate(fixingDate);
        Date endValueDate = this.maturityDate(fixingValueDate);
        double fixingDiscount = this.termStructure.getLink().discount(fixingValueDate);
        double endDiscount = this.termStructure.getLink().discount(endValueDate);
        double fixingPeriod = this.getDayCounter().yearFraction(fixingValueDate, endValueDate);
        return (fixingDiscount / endDiscount - 1.0) / fixingPeriod;
    }

    @Override
    public Handle<YieldTermStructure> getTermStructure() {
        return this.termStructure;
    }

    @Override
    public Date maturityDate(Date valueDate) {
        return this.getFixingCalendar().advance(valueDate, this.getTenor(), this.convention, this.endOfMonth);
    }

    public BusinessDayConvention getConvention() {
        return this.convention;
    }

    public boolean isEndOfMonth() {
        return this.endOfMonth;
    }
}

