/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class HongKong
extends DelegateCalendar {
    private static final HongKong HKEX_CALENDAR = new HongKong(Market.HKEx);

    private HongKong(Market market) {
        HongKongSettlementCalendar delegate;
        switch (market) {
            case HKEx: {
                delegate = new HongKongSettlementCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static HongKong getCalendar(Market market) {
        switch (market) {
            case HKEx: {
                return HKEX_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class HongKongSettlementCalendar
    extends WesternCalendar {
        private HongKongSettlementCalendar() {
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            if (this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.MONDAY) && m == Month.JANUARY || d == 5 && m == Month.APRIL || dd == em - 3 || dd == em || d == 1 && m == Month.MAY || (d == 1 || (d == 2 || d == 3) && w == Weekday.MONDAY) && m == Month.JULY || (d == 1 || (d == 2 || d == 3) && w == Weekday.MONDAY) && m == Month.OCTOBER || d == 25 && m == Month.DECEMBER || (d == 26 || (d == 27 || d == 28) && w == Weekday.MONDAY) && m == Month.DECEMBER && y < 2009) {
                return false;
            }
            if (y == 2004) {
                return !((d == 22 || d == 23 || d == 24) && m == Month.JANUARY || d == 26 && m == Month.MAY || d == 22 && m == Month.JUNE || d == 29 && m == Month.SEPTEMBER || d == 29 && m == Month.SEPTEMBER);
            }
            if (y == 2005) {
                return !((d == 9 || d == 10 || d == 11) && m == Month.FEBRUARY || d == 16 && m == Month.MAY || d == 11 && m == Month.JUNE || d == 19 && m == Month.SEPTEMBER || d == 11 && m == Month.OCTOBER);
            }
            if (y == 2006) {
                return !(d >= 28 && d <= 31 && m == Month.JANUARY || d == 5 && m == Month.MAY || d == 31 && m == Month.MAY || d == 7 && m == Month.OCTOBER || d == 30 && m == Month.OCTOBER);
            }
            if (y == 2007) {
                return !(d >= 17 && d <= 20 && m == Month.FEBRUARY || d == 24 && m == Month.MAY || d == 19 && m == Month.JUNE || d == 26 && m == Month.SEPTEMBER || d == 19 && m == Month.OCTOBER);
            }
            if (y == 2008) {
                return !(d >= 7 && d <= 9 && m == Month.FEBRUARY || d == 4 && m == Month.APRIL || d == 12 && m == Month.MAY || d == 9 && m == Month.JUNE || d == 15 && m == Month.SEPTEMBER || d == 7 && m == Month.OCTOBER);
            }
            if (y == 2008) {
                return !(d >= 7 && d <= 9 && m == Month.FEBRUARY || d == 4 && m == Month.APRIL || d == 12 && m == Month.MAY || d == 9 && m == Month.JUNE || d == 15 && m == Month.SEPTEMBER || d == 7 && m == Month.OCTOBER);
            }
            if (y == 2009) {
                return !(d >= 26 && d <= 28 && m == Month.JANUARY || d == 28 && m == Month.MAY || d == 26 && m == Month.OCTOBER);
            }
            throw new IllegalArgumentException("Year out of range");
        }

        @Override
        public String getName() {
            return "Hong Kong stock exchange";
        }
    }

    public static enum Market {
        HKEx;

    }
}

