/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.assets;

import java.util.List;
import org.jquantlib.math.Array;
import org.jquantlib.math.Closeness;
import org.jquantlib.methods.lattices.Lattice;
import org.jquantlib.time.TimeGrid;

public abstract class DiscretizedAsset {
    protected double time;
    protected double latestPreAdjustment;
    protected double latestPostAdjustment = Double.MAX_VALUE;
    protected Array values;
    private Lattice method;

    public DiscretizedAsset() {
        this.latestPreAdjustment = Double.MAX_VALUE;
    }

    public double time() {
        return this.time;
    }

    public void setTime(double t) {
        this.time = t;
    }

    public Array values() {
        return this.values;
    }

    public Lattice method() {
        return this.method;
    }

    public void initialize(Lattice method, double t) {
        this.method = method;
        method.initialize(this, t);
    }

    public void rollback(double to) {
        this.method.rollback(this, to);
    }

    public void partialRollback(double to) {
        this.method.partialRollback(this, to);
    }

    public double presentValue() {
        return this.method.presentValue(this);
    }

    public abstract void reset(int var1);

    public void preAdjustValues() {
        if (!Closeness.isCloseEnough(this.time(), this.latestPreAdjustment)) {
            this.preAdjustValuesImpl();
            this.latestPreAdjustment = this.time();
        }
    }

    public void postAdjustValues() {
        if (!Closeness.isCloseEnough(this.time(), this.latestPostAdjustment)) {
            this.postAdjustValuesImpl();
            this.latestPostAdjustment = this.time();
        }
    }

    public void adjustValues() {
        this.preAdjustValues();
        this.postAdjustValues();
    }

    public abstract List<Double> mandatoryTimes();

    protected boolean isOnTime(double t) {
        TimeGrid grid = this.method().timeGrid();
        return Closeness.isCloseEnough(grid.at(grid.index(t)), this.time());
    }

    protected void preAdjustValuesImpl() {
    }

    protected void postAdjustValuesImpl() {
    }

    public void setValues(Array newValues) {
        this.values = newValues;
    }
}

