package aQute.lib.options;

import java.lang.reflect.*;
import java.util.*;

public class Options {

	public static void arguments(OptionTarget target, String args[], int i) throws Exception {

		for (;i < args.length; i++) {
			String cmd = args[i];
			if (cmd.startsWith("-") && cmd.length() > 1 )
				i = doOption(target, cmd.substring(1), args, i);
			else {
				int n = cmd.indexOf('=');
				if (n > 0)
					target.setProperty(cmd.substring(0, n).trim(), cmd
							.substring(n + 1).trim());
				else
					target.addDefault(cmd);
			}
		}
	}

	private static int doOption(OptionTarget bean, String name, String args[],
			int i) throws Exception {
		Set had = new HashSet();
		String suffix = name.substring(0, 1).toUpperCase() + name.substring(1);
		boolean add = false;
		Method m = findMethod(bean.getClass(), "set" + suffix );
		if (m == null) {
			m = findMethod(bean.getClass(), "add" + suffix );
			add = true;
		}
		
		if (m == null)
			throw new IllegalArgumentException("No such option: " + name);

		if (!add)
			if ( had.contains(name))
				throw new IllegalArgumentException("Repeated option: " + name );

		had.add(name);
		
		Class[] types = m.getParameterTypes();
		if (types == null)
			types = new Class[0];

		Object coerced[] = new Object[types.length];
		for (int j = 0; j < types.length; j++) {
			coerced[j] = coerce(types[j], args[++i]);
		}
		m.invoke(bean, coerced);
		return i;
	}

	static Method findMethod(Class c, String name) {
		Method methods[] = c.getMethods();
		Method found = null;
		for (int i = 0; i < methods.length; i++) {
			if (methods[i].getName().equals(name)) {
				if (found != null)
					throw new IllegalArgumentException(
							"Duplicate methods for option: " + name + " on " +
									c.getName());
				found = methods[i];
			}
		}
		return found;
	}

	/**
	 * Coerce the value object into the given type.
	 * 
	 * @param c
	 *            the given type
	 * @param value
	 *            the value, usually a String. Can not be null.
	 * @return the resulting object
	 * @throws Exception
	 */
	static Object coerce(Class c, String value) throws Exception {
		if (value.equals("null"))
			return null;

		if (c == String.class)
			return value;

		if (c.isArray()) {
			String values[] = value.split("\\s*,\\s*");
			Class ctype = c.getComponentType();
			Object[] result = (Object[]) Array
					.newInstance(ctype, values.length);

			for (int i = 0; i < values.length; i++) {
				result[i] = coerce(ctype, values[i]);
			}
			return result;
		}

		if (c.isAssignableFrom(Collection.class)) {
			String values[] = value.split("\\s*,\\s*");
			Collection collection = (Collection) c.newInstance();
			for (int i = 0; i < values.length; i++) {
				collection.add(values[i]);
			}
			return collection;
		}

		if (c.isPrimitive()) {
			if (c == byte.class)
				c = Byte.class;
			else if (c == char.class)
				c = Character.class;
			else if (c == int.class)
				c = Integer.class;
			else if (c == long.class)
				c = Long.class;
			else if (c == float.class)
				c = Float.class;
			else if (c == double.class)
				c = Double.class;
			else if (c == boolean.class)
				c = Boolean.class;
			else
				throw new RuntimeException("Huh? Missing primitive: " + c);
		}
		Constructor constructor = c
				.getConstructor(new Class[] { String.class });
		return constructor.newInstance(new Object[] { value });
	}
}