package aQute.bnd.ant;

import java.io.*;
import java.util.*;

import org.apache.tools.ant.*;
import org.apache.tools.ant.types.*;

public class OrderTask extends BaseTask {
	List	bundles = new ArrayList();
	List	ordered	= new ArrayList();

	public void execute() throws BuildException {
		//System.out.println("Build order: " + ordered);
		if ( getProject().getProperty("project.order" )!=null)
			return;
		
		getProject().setProperty("project.order", join(ordered, ","));
		report();
	}

	public void addConfiguredFileSet(FileSet list) {
		DirectoryScanner scanner = list.getDirectoryScanner(getProject());
		String files[] = scanner.getIncludedFiles();
		Set set = new HashSet();
		for (int i = 0; i < files.length; i++) {
			set.add( files[i]);
		}
		traverse(ordered, set);
	}

	void traverse(List ordered, Collection dependsOn) {
		if (dependsOn == null)
			return;

		for (Iterator b = dependsOn.iterator(); b.hasNext();) {
			String bundle = (String) b.next();

			if (bundles.contains(bundle))
				continue;

			bundles.add(bundle);

			Properties p = new Properties();
			File f = getFile(getProject().getBaseDir(), bundle);
			if (f.exists()) {
				try {
					FileInputStream fin = new FileInputStream(f);
					p.load(fin);
					fin.close();
					traverse(ordered, split(p.getProperty("-dependsOn"),","));
					ordered.add(bundle);
				} catch (IOException e) {
					error("Could not load dependent bundle property file: " + f);
				}
			} else {
				error("Can not find bundle " + f);
			}
		}
	}
}
