# The bnd command line

This is a command line tool that provides almost any of the bndlib functions directly from the command line. It was
part of bnd from the first day, which was end around the year 2k, so the number of functions is very large and there is some historic remains left. That
said, it can be extremely useful. It fully supports the workspace model. It can be used to build the workspace
model without the help of Gradle or, shudder, ant.

Additionally, it provides lots of functions:

* Diagnostics
* Jar processing, diffing, flattening, adding sources, searching, extraction & printing
* Full workspace building including testing, compiling, launching, etc.
* Baselining 
* Project/workspace info
* Maven dependencies updates
* Dependency graphs
* Very extensive reporting functions 
* Eclipse functions
* nexus signing, up- and downloading
* Jar wrapping
* OSGi repository indexing
* Interacting with the remote agent in an OSGi framework
* Setup verification, especially communications that use the bnd settings
* Version bumping
* ...

The list of functions is:

          action            - Execute an action on a repo, or if no name is give, list
                              the actions 
          add               - Add a workspace, or a project or a plugin to the workspace 
          baseline          - Compare a newer bundle to a baselined bundle and provide
                              versioning advice 
          bash              - Generate autocompletion file for bash 
          bnd               - The swiss army tool for OSGi 
          bootstrap         -  
          bsn2url           -  
          build             - Build a project. This will create the jars defined in the
                              bnd.bnd and sub-builders. 
          buildtool         -  
          buildx            - Build project, is deprecated but here for backward
                              compatibility 
          bump              - Bumps the version of a project 
          changes           -  
          classpath         - Show the classpath with all the current -buildpath and
                              optional -testpath dependencies 
          classtoresource   - Convert class names to resource paths from stdin to stdout 
          clean             - Clean a project or workspace 
          collect           - Extract a set of resources from a set of JARs given a set
                              of prefixes. All prefixes in any of the given input jars
                              are added to the output jar 
          com               - Commands to verify the bnd communications setup 
          compile           - Compile a project or the workspace 
          convert           - Converter to different formats 
          copy              -  
          create            - Create jar, used to support backward compatible java jar
                              commands 
          debug             - Show a lot of info about the project you're in 
          defaults          -  
          deliverables      - Show all deliverables from this workspace. with their
                              current version and path. 
          dependencies      - Show the used workspace dependencies 
          diff              - Diff jars 
          digest            - Digests a number of files 
          do                - Execute a file based on its extension. Supported
                              extensions are: bnd (build), bndrun (run), and jar (print) 
          eclipse           - Eclipse 
          ees               - Show the Execution Environments of a JAR 
          enroute           - OSGi enRoute commands to maintain bnd workspaces (create
                              workspace, add project, etc) 
          export            -  
          exportreport      - Generate and export reports of a workspace, a project or
                              of a jar. 
          extract           - Extract files from a JAR file, equivalent jar command
                              x[vf] (syntax supported) 
          find              -  
          flatten           - Flatten a bundle by expanding all entries on the
                              Bundle-ClassPath 
          generate          - Generate source code 
          graph             - Commands to inspect a dependency graph of a set of bundles 
          grep              - Grep the manifest of bundles/jar files. 
          index             - Index bundles from the local file system 
          info              - Show key project variables 
          junit             - Test a project with plain JUnit 
          jvms              -  
          macro             - Show macro value 
          maven             - Maven bundle command 
          mbr               - Maintain Maven Bnd Repository GAV files 
          nexus             -  
          package           - Package a bnd or bndrun file into a single jar that
                              executes with java -jar <>.jar 
          packagetoresource - Convert package names to resource paths from stdin to
                              stdout 
          plugins           -  
          print             - Printout the JAR 
          profile           - Profile management. A profile is a JAR that only contains
                              packages and capabilities 
          project           - Execute a Project action, or if no parms given, show
                              information about the project 
          properties        - Show the project or the workspace properties 
          release           - Release this project 
          remote            -  
          remove            - Remove a project or a plugin from the workspace 
          repo              - Manage the repositories 
          resolve           -  
          run               - Run a project in the OSGi launcher 
          runtests          - Run OSGi tests and create report 
          schema            - Highly specialized function to create an overview of
                              package deltas in ees 
          select            - Helps finding information in a set of JARs by filtering on
                              manifest data and printing out selected information. 
          settings          - Set bnd global variables 
          shell             - Start an interactive shell 
          source            - Merge a binary jar with its sources. It is possible to
                              specify source path 
          sync              -  
          syntax            - Access the internal bnd database of keywords and options 
          test              - Test a project according to an OSGi test 
          type              - List files int a JAR file, equivalent jar command t[vf]
                              (syntax supported) 
          verify            - Verify jars 
          version           - Show version information about bnd 
          view              - View a resource from a JAR file. 
          wrap              - Wrap a jar 
          xmlrepodiff       - Shows the differences between two XML resource
                              repositories 
          xref              - Show a cross references for all classes in a set of jars. 
     
The tool is extremely useful in many cases but it is not very polished.

## Installation

For Mac users, it can be installed with [brew](https://formulae.brew.sh/formula/bnd). 

The current URL is https://repo1.maven.org/maven2/biz/aQute/bnd/biz.aQute.bnd/6.4.0/biz.aQute.bnd-6.4.0.jar

It can also be installed with [jpm](https://github.com/bndtools/jpmcli) or you can download it and run it from
the command line when you have a suitable Java VM installed:

    curl https://repo1.maven.org/maven2/biz/aQute/bnd/biz.aQute.bnd/6.4.0/biz.aQute.bnd-6.4.0.jar -o bnd.jar
    jar -jar bnd.jar





