package aQute.bnd.ant;

import java.io.*;
import java.util.*;

import org.apache.tools.ant.*;

import aQute.lib.osgi.*;

public class ExpandPropertiesTask extends BaseTask {
	File	propertyFile;

	public void execute() throws BuildException {
		try {
			if (propertyFile.exists()) {
				FileInputStream fin = new FileInputStream(propertyFile);
				Properties properties = new Properties();
				properties.putAll(getProject().getProperties());
				properties.load(fin);
				fin.close();

				Macro macro = new Macro(properties, this);
				Project project = getProject();

				for (Iterator i = properties.keySet().iterator(); i.hasNext();) {
					String key = (String) i.next();
					String value = properties.getProperty(key);
					value = macro.process(value);
					if (project.getProperty(key) == null)
						project.setProperty(key, value);
				}
			}
			report();
		} catch (IOException e) {
			e.printStackTrace();
			throw new BuildException(e);
		}
	}

	public void setPropertyFile(File file) {
		this.propertyFile = file;
	}
}
