package aQute.lib.cmdline;

import java.io.*;

public class ANSI implements Terminal {
	CommandLineEditor	editor;
	
	public ANSI(CommandLineEditor editor) {
		this.editor = editor;
	}
	
	public void process(InputStream in) throws IOException {
		int previous = -1;
		while ( true ) {
			int c = in.read();
			switch( c ) {
			case -1: 
				return;
				
			case '\r':	// return
				editor.newline();
				break;
				
			case '\n':	// line feed
				if ( previous != '\r' )
					editor.newline();
				break;
				
			case '\b':	// backspace
				editor.backspace();
				break;
				
			case '\u0003':	// control-c
				editor.abort();
				break;

			case '\u007F':	// delete
				editor.delete();
				break;
				
			case '\u001B': // escape()
				escape(in);
				break;
				
			case '\u00FF': // IAC (telnet)
				iac();
				break;
				
			default:
				editor.put(c);
				break;
			}
			
			previous = c;
		}
	}
	
	private void iac() {
		// TODO Auto-generated method stub
		
	}

	void escape(InputStream in) {
//		int c = in.getNext();
//		if ( c != 0x5B ) {
//			editor.put()
//		}
	}

	public void clear() {
		// TODO Auto-generated method stub
		
	}

	public void display(String s) {
		// TODO Auto-generated method stub
		
	}

	public void eraseEOL() {
		// TODO Auto-generated method stub
		
	}

	public void home() {
		// TODO Auto-generated method stub
		
	}
	
}
