/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.pl;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "\u015awiat" },
            { "002", "Afryka" },
            { "003", "Ameryka P\u00f3\u0142nocna" },
            { "005", "Ameryka Po\u0142udniowa" },
            { "009", "Oceania" },
            { "011", "Afryka Zachodnia" },
            { "013", "Ameryka \u015arodkowa" },
            { "014", "Afryka Wschodnia" },
            { "015", "Afryka P\u00f3\u0142nocna" },
            { "017", "Afryka \u015arodkowa" },
            { "018", "Afryka Po\u0142udniowa" },
            { "019", "Ameryka" },
            { "021", "Ameryka P\u00f3\u0142nocna - Kanada, USA" },
            { "029", "Karaiby" },
            { "030", "Azja Wschodnia" },
            { "034", "Azja Po\u0142udniowa" },
            { "035", "Azja Po\u0142udniowo-Wschodnia" },
            { "039", "Europa Po\u0142udniowa" },
            { "053", "Australia i Nowa Zelandia" },
            { "054", "Melanezja" },
            { "057", "Mikronezja" },
            { "061", "Polinezja" },
            { "142", "Azja" },
            { "143", "Azja \u015arodkowa" },
            { "145", "Azja Zachodnia" },
            { "150", "Europa" },
            { "151", "Europa Wschodnia" },
            { "154", "Europa P\u00f3\u0142nocna" },
            { "155", "Europa Zachodnia" },
            { "419", "Ameryka \u0141aci\u0144ska" },
            { "AC", "Wyspa Wniebowst\u0105pienia" },
            { "AD", "Andora" },
            { "AE", "Zjednoczone Emiraty Arabskie" },
            { "AF", "Afganistan" },
            { "AG", "Antigua i Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AN", "Antyle Holenderskie" },
            { "AO", "Angola" },
            { "AQ", "Antarktyka" },
            { "AR", "Argentyna" },
            { "AS", "Samoa Ameryka\u0144skie" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Wyspy Alandzkie" },
            { "AZ", "Azerbejd\u017can" },
            { "BA", "Bo\u015bnia i Hercegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesz" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bu\u0142garia" },
            { "BH", "Bahrajn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermudy" },
            { "BN", "Brunei Darussalam" },
            { "BO", "Boliwia" },
            { "BR", "Brazylia" },
            { "BS", "Bahamy" },
            { "BT", "Bhutan" },
            { "BV", "Wyspa Bouveta" },
            { "BW", "Botswana" },
            { "BY", "Bia\u0142oru\u015b" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Wyspy Kokosowe" },
            { "CD", "Demokratyczna Republika Konga" },
            { "CF", "Republika \u015arodkowoafryka\u0144ska" },
            { "CG", "Kongo" },
            { "CH", "Szwajcaria" },
            { "CI", "Wybrze\u017ce Ko\u015bci S\u0142oniowej" },
            { "CK", "Wyspy Cooka" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Chiny" },
            { "CO", "Kolumbia" },
            { "CP", "Clipperton" },
            { "CR", "Kostaryka" },
            { "CS", "Serbia i Czarnog\u00f3ra" },
            { "CU", "Kuba" },
            { "CV", "Republika Zielonego Przyl\u0105dka" },
            { "CX", "Wyspa Bo\u017cego Narodzenia" },
            { "CY", "Cypr" },
            { "CZ", "Czechy" },
            { "DE", "Niemcy" },
            { "DG", "Diego Garcia" },
            { "DJ", "D\u017cibuti" },
            { "DK", "Dania" },
            { "DM", "Dominika" },
            { "DO", "Republika Dominika\u0144ska" },
            { "DZ", "Algieria" },
            { "EA", "Ceuta i Melilla" },
            { "EC", "Ekwador" },
            { "EE", "Estonia" },
            { "EG", "Egipt" },
            { "EH", "Sahara Zachodnia" },
            { "ER", "Erytrea" },
            { "ES", "Hiszpania" },
            { "ET", "Etiopia" },
            { "EU", "Unia Europejska" },
            { "FI", "Finlandia" },
            { "FJ", "Fid\u017ci" },
            { "FK", "Falklandy" },
            { "FM", "Federalne Stany Mikronezji" },
            { "FO", "Wyspy Owcze" },
            { "FR", "Francja" },
            { "FX", "Francja metropolitalna" },
            { "GA", "Gabon" },
            { "GB", "Wielka Brytania" },
            { "GD", "Grenada" },
            { "GE", "Gruzja" },
            { "GF", "Gujana Francuska" },
            { "GG", "Wyspa Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grenlandia" },
            { "GM", "Gambia" },
            { "GN", "Gwinea" },
            { "GP", "Gwadelupa" },
            { "GQ", "Gwinea R\u00f3wnikowa" },
            { "GR", "Grecja" },
            { "GS", "Georgia Po\u0142udniowa i Sandwich Po\u0142udniowy" },
            { "GT", "Gwatemala" },
            { "GU", "Guam" },
            { "GW", "Gwinea Bissau" },
            { "GY", "Gujana" },
            { "HK", "Hongkong SAR" },
            { "HM", "Wyspy Heard i McDonalda" },
            { "HN", "Honduras" },
            { "HR", "Chorwacja" },
            { "HT", "Haiti" },
            { "HU", "W\u0119gry" },
            { "IC", "Wyspy Kanaryjskie" },
            { "ID", "Indonezja" },
            { "IE", "Irlandia" },
            { "IL", "Izrael" },
            { "IM", "Wyspa Man" },
            { "IN", "Indie" },
            { "IO", "Terytorium Brytyjskie Oceanu Indyjskiego" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandia" },
            { "IT", "W\u0142ochy" },
            { "JE", "Wyspa Jersey" },
            { "JM", "Jamajka" },
            { "JO", "Jordania" },
            { "JP", "Japonia" },
            { "KE", "Kenia" },
            { "KG", "Kirgistan" },
            { "KH", "Kambod\u017ca" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "KN", "Saint Kitts i Nevis" },
            { "KP", "Korea P\u00f3\u0142nocna" },
            { "KR", "Korea Po\u0142udniowa" },
            { "KW", "Kuwejt" },
            { "KY", "Kajmany" },
            { "KZ", "Kazachstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litwa" },
            { "LU", "Luksemburg" },
            { "LV", "\u0141otwa" },
            { "LY", "Libia" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Mo\u0142dawia" },
            { "ME", "Czarnog\u00f3ra" },
            { "MF", "Sint Maarten" },
            { "MG", "Madagaskar" },
            { "MH", "Wyspy Marshalla" },
            { "MK", "Macedonia" },
            { "ML", "Mali" },
            { "MM", "Birma" },
            { "MN", "Mongolia" },
            { "MO", "Makau SAR" },
            { "MP", "Mariany P\u00f3\u0142nocne" },
            { "MQ", "Martynika" },
            { "MR", "Mauretania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediwy" },
            { "MW", "Malawi" },
            { "MX", "Meksyk" },
            { "MY", "Malezja" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "Nowa Kaledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", "Holandia" },
            { "NO", "Norwegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nowa Zelandia" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinezja Francuska" },
            { "PG", "Papua Nowa Gwinea" },
            { "PH", "Filipiny" },
            { "PK", "Pakistan" },
            { "PL", "Polska" },
            { "PM", "Saint-Pierre i Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Portoryko" },
            { "PS", "Terytoria Palesty\u0144skie" },
            { "PT", "Portugalia" },
            { "PW", "Palau" },
            { "PY", "Paragwaj" },
            { "QA", "Katar" },
            { "QO", "Oceania inne" },
            { "RE", "Reunion" },
            { "RO", "Rumunia" },
            { "RS", "Serbia" },
            { "RU", "Rosja" },
            { "RW", "Rwanda" },
            { "SA", "Arabia Saudyjska" },
            { "SB", "Wyspy Salomona" },
            { "SC", "Seszele" },
            { "SD", "Sudan" },
            { "SE", "Szwecja" },
            { "SG", "Singapur" },
            { "SH", "Wyspa \u015awi\u0119tej Heleny" },
            { "SI", "S\u0142owenia" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "SK", "S\u0142owacja" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "ST", "Wyspy \u015awi\u0119tego Tomasza i Ksi\u0105\u017c\u0119ca" },
            { "SV", "Salwador" },
            { "SY", "Syria" },
            { "SZ", "Suazi" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks i Caicos" },
            { "TD", "Czad" },
            { "TF", "Francuskie Terytoria Po\u0142udniowe" },
            { "TG", "Togo" },
            { "TH", "Tajlandia" },
            { "TJ", "Tad\u017cykistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor Wschodni" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunezja" },
            { "TO", "Tonga" },
            { "TR", "Turcja" },
            { "TT", "Trynidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Dalekie Wyspy Mniejsze Stan\u00f3w Zjednoczonych" },
            { "US", "Stany Zjednoczone" },
            { "UY", "Urugwaj" },
            { "UZ", "Uzbekistan" },
            { "VA", "Watykan" },
            { "VC", "Saint Vincent i Grenadyny" },
            { "VE", "Wenezuela" },
            { "VG", "Brytyjskie Wyspy Dziewicze" },
            { "VI", "Wyspy Dziewicze Stan\u00f3w Zjednoczonych" },
            { "VN", "Wietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis i Futuna" },
            { "WS", "Samoa" },
            { "YE", "Jemen" },
            { "YT", "Majotta" },
            { "ZA", "Republika Po\u0142udniowej Afryki" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Nieznany lub nieprawid\u0142owy region" },
            { "aa", "afar" },
            { "ab", "abchaski" },
            { "ae", "awestyjski" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharski" },
            { "an", "arago\u0144ski" },
            { "ar", "arabski" },
            { "as", "asamski" },
            { "av", "awarski" },
            { "ay", "ajmara" },
            { "az", "azerski" },
            { "ba", "baszkirski" },
            { "be", "bia\u0142oruski" },
            { "bg", "bu\u0142garski" },
            { "bh", "biharski" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengalski" },
            { "bo", "tybeta\u0144ski" },
            { "br", "breto\u0144ski" },
            { "bs", "bo\u015bniacki" },
            { "ca", "katalo\u0144ski" },
            { "ce", "czecze\u0144ski" },
            { "ch", "chamorro" },
            { "co", "korsyka\u0144ski" },
            { "cr", "kri" },
            { "cs", "czeski" },
            { "cu", "staro-cerkiewno-s\u0142owia\u0144ski" },
            { "cv", "czuwaski" },
            { "cy", "walijski" },
            { "da", "du\u0144ski" },
            { "de", "niemiecki" },
            { "dv", "malediwski" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "grecki" },
            { "en", "angielski" },
            { "eo", "esperanto" },
            { "es", "hiszpa\u0144ski" },
            { "et", "esto\u0144ski" },
            { "eu", "baskijski" },
            { "fa", "perski" },
            { "ff", "fulani" },
            { "fi", "fi\u0144ski" },
            { "fj", "fid\u017cijski" },
            { "fo", "farerski" },
            { "fr", "francuski" },
            { "fy", "fryzyjski" },
            { "ga", "irlandzki" },
            { "gd", "szkocki gaelicki" },
            { "gl", "galisyjski" },
            { "gn", "guarani" },
            { "gu", "gud\u017aaracki" },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", "hebrajski" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "chorwacki" },
            { "ht", "haita\u0144ski" },
            { "hu", "w\u0119gierski" },
            { "hy", "ormia\u0144ski" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonezyjski" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "syczua\u0144ski" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandzki" },
            { "it", "w\u0142oski" },
            { "iu", "inuktitut" },
            { "ja", "japo\u0144ski" },
            { "jv", "jawajski" },
            { "ka", "gruzi\u0144ski" },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kwanyama" },
            { "kk", "kazachski" },
            { "kl", "grenlandzki" },
            { "km", "khmerski" },
            { "kn", "kannada" },
            { "ko", "korea\u0144ski" },
            { "kr", "kanuri" },
            { "ks", "kaszmirski" },
            { "ku", "kurdyjski" },
            { "kv", "komi" },
            { "kw", "kornijski" },
            { "ky", "kirgiski" },
            { "la", "\u0142aci\u0144ski" },
            { "lb", "luksemburski" },
            { "lg", "ganda" },
            { "li", "limburgijski" },
            { "ln", "lingala" },
            { "lo", "laota\u0144ski" },
            { "lt", "litewski" },
            { "lu", "luba-katanga" },
            { "lv", "\u0142otewski" },
            { "mg", "malgaski" },
            { "mh", "marshall" },
            { "mi", "maoryjski" },
            { "mk", "macedo\u0144ski" },
            { "ml", "malajalam" },
            { "mn", "mongolski" },
            { "mo", "mo\u0142dawski" },
            { "mr", "marathi" },
            { "ms", "malajski" },
            { "mt", "malta\u0144ski" },
            { "my", "birma\u0144ski" },
            { "na", "nauru" },
            { "nb", "norweski Bokm\u00e5l" },
            { "nd", "ndebele p\u00f3\u0142nocny" },
            { "ne", "nepalski" },
            { "ng", "ndonga" },
            { "nl", "niderlandzki" },
            { "nn", "norweski Nynorsk" },
            { "no", "norweski" },
            { "nr", "ndebele po\u0142udniowy" },
            { "nv", "nawaho" },
            { "ny", "njand\u017ca" },
            { "oc", "prowansalski" },
            { "oj", "od\u017cibwa" },
            { "om", "oromski" },
            { "or", "orija" },
            { "os", "osetyjski" },
            { "pa", "pend\u017cabski" },
            { "pi", "palijski" },
            { "pl", "polski" },
            { "ps", "paszto" },
            { "pt", "portugalski" },
            { "qu", "keczua" },
            { "rm", "retoroma\u0144ski" },
            { "rn", "rundi" },
            { "ro", "rumu\u0144ski" },
            { "ru", "rosyjski" },
            { "rw", "kinya-ruanda" },
            { "sa", "sanskryt" },
            { "sc", "sardy\u0144ski" },
            { "sd", "sindhi" },
            { "se", "lapo\u0144ski p\u00f3\u0142nocny" },
            { "sg", "sango" },
            { "sh", "serbsko-chorwacki" },
            { "si", "syngaleski" },
            { "sk", "s\u0142owacki" },
            { "sl", "s\u0142owe\u0144ski" },
            { "sm", "samoa\u0144ski" },
            { "sn", "szona" },
            { "so", "somalijski" },
            { "sq", "alba\u0144ski" },
            { "sr", "serbski" },
            { "ss", "siswati" },
            { "st", "sotho po\u0142udniowy" },
            { "su", "sundajski" },
            { "sv", "szwedzki" },
            { "sw", "suahili" },
            { "ta", "tamilski" },
            { "te", "telugu" },
            { "tg", "tad\u017cycki" },
            { "th", "tajski" },
            { "ti", "tigrinia" },
            { "tk", "turkme\u0144ski" },
            { "tl", "tagalski" },
            { "tn", "setswana" },
            { "to", "tonga" },
            { "tr", "turecki" },
            { "ts", "tsonga" },
            { "tt", "tatarski" },
            { "tw", "twi" },
            { "ty", "tahita\u0144ski" },
            { "ug", "ujgurski" },
            { "uk", "ukrai\u0144ski" },
            { "ur", "urdu" },
            { "uz", "uzbecki" },
            { "ve", "venda" },
            { "vi", "wietnamski" },
            { "vo", "volapuk" },
            { "wa", "walo\u0144ski" },
            { "wo", "wolof" },
            { "xh", "khosa" },
            { "yi", "jidysz" },
            { "yo", "joruba" },
            { "za", "czuang" },
            { "zh", "chi\u0144ski" },
            { "zu", "zulu" },
            { "ace", "aceh" },
            { "ach", "aczoli" },
            { "ada", "adangme" },
            { "ady", "adygejski" },
            { "afa", "afro-azjatycki" },
            { "afh", "afrihili" },
            { "ain", "ajnu" },
            { "akk", "akadyjski" },
            { "ale", "aleucki" },
            { "alg", "j\u0119zyki algonkin" },
            { "alt", "po\u0142udniowoa\u0142tajski" },
            { "ang", "staroangielski" },
            { "anp", "angika" },
            { "apa", "j\u0119zyk Apacz\u00f3w" },
            { "arc", "aramejski" },
            { "arn", "arauka\u0144ski" },
            { "arp", "arapaho" },
            { "art", "sztuczny" },
            { "arw", "arawak" },
            { "ast", "asturyjski" },
            { "ath", "j\u0119zyk Atapask\u00f3w" },
            { "aus", "j\u0119zyk australijski" },
            { "awa", "awadhi" },
            { "bad", "j\u0119zyk banda" },
            { "bai", "j\u0119zyk bamileke" },
            { "bal", "belud\u017ci" },
            { "ban", "balijski" },
            { "bas", "basa" },
            { "bat", "ba\u0142tycki" },
            { "bej", "bed\u017ca" },
            { "bem", "bemba" },
            { "ber", "berberski" },
            { "bho", "bhod\u017apuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "bnt", "bantu" },
            { "bra", "brad\u017a" },
            { "btk", "batak" },
            { "bua", "buriacki" },
            { "bug", "bugi\u0144ski" },
            { "byn", "blin" },
            { "cad", "kaddo" },
            { "cai", "j\u0119zyk Indian \u015brodkowoameryka\u0144skich" },
            { "car", "karibi" },
            { "cau", "kaukaski" },
            { "cch", "atsam" },
            { "ceb", "cebuano" },
            { "cel", "celtycki" },
            { "chb", "czibcza" },
            { "chg", "czagatajski" },
            { "chk", "truk" },
            { "chm", "maryjski" },
            { "chn", "\u017cargon Chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "czirokezki" },
            { "chy", "j\u0119zyk Czejen\u00f3w" },
            { "cmc", "czam" },
            { "cop", "koptyjski" },
            { "cpe", "angielski kreolski lub pid\u017cin" },
            { "cpf", "francuski kreolski lub pid\u017cin" },
            { "cpp", "portugalski kreolski lub pid\u017cin" },
            { "crh", "krymski turecki" },
            { "crp", "kreolski lub pid\u017cin" },
            { "csb", "kaszubski" },
            { "cus", "kuszycki" },
            { "dak", "dakota" },
            { "dar", "dargwijski" },
            { "day", "dajak" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "doi", "dogri" },
            { "dra", "drawidyjski" },
            { "dsb", "dolno\u0142u\u017cycki" },
            { "dua", "duala" },
            { "dum", "\u015bredniowieczny niderlandzki" },
            { "dyu", "dyula" },
            { "efi", "efik" },
            { "egy", "staro\u017cytny egipski" },
            { "eka", "ekajuk" },
            { "elx", "elamicki" },
            { "enm", "\u015brednioangielski" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fiu", "ugrofi\u0144ski" },
            { "fon", "fon" },
            { "frm", "\u015bredniofrancuski" },
            { "fro", "starofrancuski" },
            { "frr", "p\u00f3\u0142nocnofryzyjski" },
            { "frs", "fryzyjski wschodni" },
            { "fur", "friulijski" },
            { "gaa", "ga" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gem", "germa\u0144ski" },
            { "gez", "gyyz" },
            { "gil", "gilberta\u0144ski" },
            { "gmh", "\u015brednio-wysoko-niemiecki" },
            { "goh", "staro-wysoko-niemiecki" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gocki" },
            { "grb", "grebo" },
            { "grc", "starogrecki" },
            { "gsw", "niemiecki (Szwajcaria)" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "haw", "hawajski" },
            { "hil", "hiligajnon" },
            { "him", "himachali" },
            { "hit", "hetycki" },
            { "hmn", "hmongijski" },
            { "hsb", "g\u00f3rno\u0142u\u017cycki" },
            { "hup", "hupa" },
            { "iba", "ibanag" },
            { "ijo", "ijo" },
            { "ilo", "ilokano" },
            { "inc", "indoaryjski" },
            { "ine", "indoeuropejski" },
            { "inh", "inguski" },
            { "ira", "ira\u0144ski" },
            { "iro", "irokeski" },
            { "jbo", "lojban" },
            { "jpr", "judeoperski" },
            { "jrb", "judeoarabski" },
            { "kaa", "karaka\u0142packi" },
            { "kab", "kabylski" },
            { "kac", "kaczin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kar", "kare\u0144ski" },
            { "kaw", "kawi" },
            { "kbd", "kabardyjski" },
            { "kcg", "tyap" },
            { "kfo", "koro" },
            { "kha", "khasi" },
            { "khi", "khoisan" },
            { "kho", "chota\u0144ski" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", "kpelle" },
            { "krc", "karaczajsko-ba\u0142karski" },
            { "krl", "karelski" },
            { "kro", "kru" },
            { "kru", "kurukh" },
            { "kum", "kumycki" },
            { "kut", "kutenai" },
            { "lad", "lady\u0144ski" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgijski" },
            { "lol", "mongo" },
            { "loz", "lozi" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "mad", "madurajski" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "map", "austronezyjski" },
            { "mas", "masajski" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mga", "\u015brednioirlandzki" },
            { "mic", "micmac" },
            { "min", "minangkabu" },
            { "mis", "inny j\u0119zyk" },
            { "mkh", "mon-khmer" },
            { "mnc", "manchu" },
            { "mni", "manipuryjski" },
            { "mno", "manobo" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mul", "wiele j\u0119zyk\u00f3w" },
            { "mun", "mundajski" },
            { "mus", "creek" },
            { "mwl", "mirandese" },
            { "mwr", "marwari" },
            { "myn", "j\u0119zyk Maj\u00f3w" },
            { "myv", "erzya" },
            { "nah", "nahuatl" },
            { "nai", "j\u0119zyk Indian p\u00f3\u0142nocnoameryka\u0144skich" },
            { "nap", "neapolita\u0144ski" },
            { "nds", "dolnosakso\u0144ski" },
            { "new", "newarski" },
            { "nia", "nias" },
            { "nic", "nigrokordofa\u0144ski" },
            { "niu", "niue" },
            { "nog", "nogajski" },
            { "non", "staronordyjski" },
            { "nqo", "n\u2019ko" },
            { "nso", "sotho p\u00f3\u0142nocny" },
            { "nub", "nubijski" },
            { "nwc", "newarski klasyczny" },
            { "nym", "niamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzema" },
            { "osa", "osage" },
            { "ota", "osma\u0144sko-turecki" },
            { "oto", "otomi" },
            { "paa", "papuaski" },
            { "pag", "pangasino" },
            { "pal", "pahlavi" },
            { "pam", "pampango" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "peo", "staroperski" },
            { "phi", "filipi\u0144ski" },
            { "phn", "fenicki" },
            { "pon", "ponpejski" },
            { "pra", "prakryty" },
            { "pro", "staroprowansalski" },
            { "raj", "rad\u017aasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "roa", "roma\u0144ski" },
            { "rom", "cyga\u0144ski" },
            { "rup", "arumu\u0144ski" },
            { "sad", "sandawe" },
            { "sah", "jakucki" },
            { "sai", "j\u0119zyk Indian po\u0142udniowoameryka\u0144skich" },
            { "sal", "salisz" },
            { "sam", "samaryta\u0144ski aramejski" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "scn", "sycylijski" },
            { "sco", "szkocki" },
            { "sel", "selkupski" },
            { "sem", "semicki" },
            { "sga", "staroirlandzki" },
            { "sgn", "migowy" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "sio", "sioua\u0144ski" },
            { "sit", "chi\u0144sko-tybeta\u0144ski" },
            { "sla", "s\u0142owia\u0144ski" },
            { "sma", "lapo\u0144ski po\u0142udniowy" },
            { "smi", "lapo\u0144ski" },
            { "smj", "lapo\u0144ski Lule" },
            { "smn", "lapo\u0144ski Inari" },
            { "sms", "lapo\u0144ski Skolt" },
            { "snk", "soninke" },
            { "sog", "sogdyjski" },
            { "son", "songhaj" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssa", "nilosaharyjski" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeryjski" },
            { "swb", "komoryjski" },
            { "syc", "syriacki" },
            { "syr", "syryjski" },
            { "tem", "temne" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tig", "tigre" },
            { "tiv", "tiw" },
            { "tkl", "tokelau" },
            { "tlh", "klingo\u0144ski" },
            { "tli", "tlingit" },
            { "tmh", "tamaszek" },
            { "tog", "tonga (Niasa)" },
            { "tpi", "tok pisin" },
            { "tsi", "tsimshian" },
            { "tum", "tumbuka" },
            { "tup", "tupi" },
            { "tut", "a\u0142tajski" },
            { "tvl", "tuvalu" },
            { "tyv", "tuwi\u0144ski" },
            { "udm", "udmurcki" },
            { "uga", "ugarycki" },
            { "umb", "umbundu" },
            { "und", "nieznany lub niepoprawny j\u0119zyk" },
            { "vai", "wai" },
            { "vot", "wotiacki" },
            { "wak", "wakasz" },
            { "wal", "walamo" },
            { "war", "waraj" },
            { "was", "washo" },
            { "wen", "\u0142u\u017cycki" },
            { "xal", "ka\u0142mucki" },
            { "yao", "yao" },
            { "yap", "japski" },
            { "ypk", "jupik" },
            { "yue", "kanto\u0144ski" },
            { "zap", "zapotecki" },
            { "zbl", "bliss" },
            { "zen", "zenaga" },
            { "znd", "azande" },
            { "zun", "zuni" },
            { "zxx", "brak tre\u015bci o charakterze lingwistycznym" },
            { "zza", "zazaki" },
            { "Arab", "arabskie" },
            { "Armi", "armi" },
            { "Armn", "ormia\u0144skie" },
            { "Avst", "awestyjskie" },
            { "Bali", "balijskie" },
            { "Batk", "batak" },
            { "Beng", "bengalskie" },
            { "Blis", "symbole Blissa" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "Braille\u2019a" },
            { "Bugi", "bugi\u0144skie" },
            { "Buhd", "buhid" },
            { "Cakm", "chakma" },
            { "Cans", "zunifikowane symbole kanadyjskich autochton\u00f3w" },
            { "Cari", "karyjskie" },
            { "Cham", "czamskie" },
            { "Cher", "irokeski" },
            { "Cirt", "cirth" },
            { "Copt", "koptyjskie" },
            { "Cprt", "cypryjskie" },
            { "Cyrl", "cyrylica" },
            { "Cyrs", "cyrylica staro-cerkiewno-s\u0142owia\u0144ska" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Egyd", "egipskie demotyczne" },
            { "Egyh", "egipskie hieratyczne" },
            { "Egyp", "hieroglify egipskie" },
            { "Ethi", "etiopskie" },
            { "Geok", "gruzi\u0144skie chucuri" },
            { "Geor", "gruzi\u0144skie" },
            { "Glag", "g\u0142agolica" },
            { "Goth", "gotyckie" },
            { "Grek", "greckie" },
            { "Gujr", "gud\u017aarackie" },
            { "Guru", "gurmukhi" },
            { "Hang", "hangyl" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "uproszczony han" },
            { "Hant", "tradycyjny han" },
            { "Hebr", "hebrajskie" },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "katakana lub hiragana" },
            { "Hung", "starow\u0119gierskie" },
            { "Inds", "indus" },
            { "Ital", "starow\u0142oskie" },
            { "Java", "jawajskie" },
            { "Jpan", "japo\u0144skie" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "charosti" },
            { "Khmr", "khmerskie" },
            { "Knda", "kannada" },
            { "Kore", "korea\u0144skie" },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", "laota\u0144skie" },
            { "Latf", "\u0142aci\u0144ski - fraktura" },
            { "Latg", "\u0142aci\u0144ski - odmiana gaelicka" },
            { "Latn", "\u0142aci\u0144skie" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "linearne A" },
            { "Linb", "linearne B" },
            { "Lyci", "likijskie" },
            { "Lydi", "lidyjskie" },
            { "Mand", "mandejskie" },
            { "Mani", "manichejskie" },
            { "Maya", "hieroglify Maj\u00f3w" },
            { "Mero", "meroickie" },
            { "Mlym", "malayalam" },
            { "Mong", "mongolskie" },
            { "Moon", "Moon'a" },
            { "Mtei", "meitei mayek" },
            { "Mymr", "birma\u0144skie" },
            { "Nkoo", "n'ko" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orcho\u0144skie" },
            { "Orya", "oriya" },
            { "Osma", "osmanya" },
            { "Perm", "staropermskie" },
            { "Phag", "phags-pa" },
            { "Phli", "inskrypcyjne pahlawi" },
            { "Phlp", "pahlawi psa\u0142terzowy" },
            { "Phlv", "pahlawi ksi\u0105\u017ckowy" },
            { "Phnx", "fenicki" },
            { "Plrd", "fonetyczny Pollard'a" },
            { "Prti", "partyjski inskrypcyjny" },
            { "Rjng", "rejang" },
            { "Roro", "rongorongo" },
            { "Runr", "runiczne" },
            { "Samr", "samaryta\u0144ski" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "pismo znakowe" },
            { "Shaw", "shawa" },
            { "Sinh", "syngaleskie" },
            { "Sund", "sundajskie" },
            { "Sylo", "syloti nagri" },
            { "Syrc", "syryjski" },
            { "Syre", "syriacki estrangelo" },
            { "Syrj", "syryjski (odmiana zachodnia)" },
            { "Syrn", "syryjski (odmiana wschodnia)" },
            { "Tagb", "tagbanwa" },
            { "Tale", "tai le" },
            { "Talu", "nowy tai lue" },
            { "Taml", "tamilskie" },
            { "Tavt", "tai viet" },
            { "Telu", "telugu" },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh (berberski)" },
            { "Tglg", "tagalog" },
            { "Thaa", "thaana" },
            { "Thai", "tajskie" },
            { "Tibt", "tybeta\u0144skie" },
            { "Ugar", "ugaryckie" },
            { "Vaii", "vai" },
            { "Visp", "Visible Speech" },
            { "Xpeo", "staroperskie" },
            { "Xsux", "klinowe sumero-akadyjskie" },
            { "Yiii", "yi" },
            { "Zinh", "dziedziczone" },
            { "Zmth", "notacja matematyczna" },
            { "Zsym", "Symbols" },
            { "Zxxx", "j\u0119zyk bez systemu pisma" },
            { "Zyyy", "wsp\u00f3lne" },
            { "Zzzz", "nieznane lub niepoprawne" },
            { "root", "j\u0119zyk rdzenny" },
            { "de_AT", "austriacki niemiecki" },
            { "de_CH", "wysokoniemiecki (Szwajcaria)" },
            { "en_CA", "kanadyjski angielski" },
            { "en_GB", "brytyjski angielski" },
            { "en_US", "angielski (USA)" },
            { "fr_CA", "kanadyjski francuski" },
            { "nl_BE", "flamandzki (Belgia)" },
            { "pt_PT", "portugalski (P\u00f3\u0142wysep Iberyjski)" },
            { "zh_Hans", "chi\u0144ski (uproszczony)" },
            { "zh_Hant", "chi\u0144ski (tradycyjny)" },
        };
        return data;
    }
}
